package io.privy.wallet.solana

public interface EmbeddedSolanaWalletProvider {
  /**
   * Request a signature on a Base64 encoded message or transaction. Example usage:
   *
   * ```kotlin
   * solanaEmbeddedWallet.provider.signMessage(
   *    // Base 64 encoded: "Hello! I am the base64 encoded message to be signed."
   *    "SGVsbG8hIEkgYW0gdGhlIGJhc2U2NCBlbmNvZGVkIG1lc3NhZ2UgdG8gYmUgc2lnbmVkLg=="
   * )
   * ```
   *
   * @param message Base64 encoded message or transaction
   * @return The Base64 encoded computed signature
   */
  public suspend fun signMessage(message: String): Result<String>
}