package io.privy.wallet

import io.privy.wallet.ethereum.EthereumRpcRequest
import io.privy.wallet.ethereum.EthereumRpcResponse
import io.privy.wallet.solana.SolanaRpcRequest
import io.privy.wallet.solana.SolanaSignMessageResponse

public interface EmbeddedWalletManager {
  /**
   * Creates a new Ethereum embedded wallet for the user
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createEthereumWallet(
      accessToken: String,
      existingSolanaWalletAddress: String?,
  ): Result<String>

  /**
   * Creates a new HD embedded wallet for the user.
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createAdditionalWallet(
      accessToken: String,
      primaryWalletAddress: String,
      hdWalletIndex: Int,
  ): Result<String>

  /**
   * Creates a new Solana embedded wallet for the user
   *
   * @return A result type with the newly created wallet address or a failure
   */
  public suspend fun createSolanaWallet(
      accessToken: String,
      existingEthereumWalletAddress: String?,
  ): Result<String>

  public suspend fun ethereumRpc(
      embeddedWalletDetails: EmbeddedWalletDetails,
      request: EthereumRpcRequest
  ): Result<EthereumRpcResponse>

  public suspend fun solanaRpc(
      embeddedWalletDetails: EmbeddedWalletDetails,
      request: SolanaRpcRequest
  ): Result<SolanaSignMessageResponse>

  public suspend fun attemptConnectWalletInBackground()
}
