package io.privy.wallet

import io.privy.wallet.ethereum.EthereumRpcRequest
import io.privy.wallet.ethereum.EthereumRpcResponse
import io.privy.wallet.solana.SolanaRpcRequest
import io.privy.wallet.solana.SolanaSignMessageResponse

public interface EmbeddedWalletManager {
  /**
   * Creates an ethereum wallet
   *
   * @param primaryEthereumWalletAddress Address of the user's existing primary ethereum wallet, or null if it doesn't exist
   * @param ethereumWalletsCount Current count of ethereum wallets
   * @param primarySolanaWalletAddress Address of the user's existing primary solana wallet, if it exists
   * @param allowAdditional If creating an HD wallet is allows
   *
   * @return The address of the newly created wallet
   */
  public suspend fun createEthereumWallet(
    allowAdditional: Boolean
  ): Result<String>

  public suspend fun createSolanaWallet(
    allowAdditional: Boolean,
  ): Result<String>

  public suspend fun ethereumRpc(
      embeddedWalletDetails: EmbeddedWalletDetails,
      request: EthereumRpcRequest
  ): Result<EthereumRpcResponse>

  public suspend fun solanaRpc(
      embeddedWalletDetails: EmbeddedWalletDetails,
      request: SolanaRpcRequest
  ): Result<SolanaSignMessageResponse>

  public fun connectWalletIfNeeded()
}
