package io.privy.wallet.rpc

import io.privy.wallet.solana.SolanaRpcRequest
import kotlinx.serialization.Serializable

@Serializable
public sealed interface SolanaRpcRequestBody : RpcRequestInfo {
    public val method: String

    @Serializable
    public data class SignMessageRequest(override val method: String, val params: SolanaSignMessageParams) :
        SolanaRpcRequestBody
}

@Serializable
public data class SolanaSignMessageParams(val message: String)

// SolanaRpcRequestParams extensions to convert to SolanaRpcRequest
public fun SolanaRpcRequest.rpcRequest(): SolanaRpcRequestBody.SignMessageRequest =
    when (this) {
        is SolanaRpcRequest.SignMessageParams ->
            SolanaRpcRequestBody.SignMessageRequest(
                method = "signMessage", params = SolanaSignMessageParams(message = this.message))
    }
