package io.privy.wallet.webview

import kotlin.jvm.JvmInline

/**
 * This class is a simplified model that represents success / error after injected javascript into
 * the privy webview. We should use this as return types to functions, instead of
 * PrivyIFrameErrorResponse and PrivyIFrameSuccessResponse, whose main job is to deserialize the
 * responses into models.
 */
public sealed interface IFrameResponse<out T> {
  @JvmInline public value class Success<T>(public val value: T) : IFrameResponse<T>

  public data class Error<T>(val type: String, val message: String) : IFrameResponse<T>
}
