/*
 * Decompiled with CFR 0.152.
 */
package io.privy.logging;

import io.privy.logging.PrivyLogLevel;
import io.privy.logging.PrivyLogger;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.tatarka.inject.annotations.Inject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Inject
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/privy/logging/RealPrivyLogger;", "Lio/privy/logging/PrivyLogger;", "level", "Lio/privy/logging/PrivyLogLevel;", "appId", "", "Lio/privy/di/PrivyAppId;", "<init>", "(Lio/privy/logging/PrivyLogLevel;Ljava/lang/String;)V", "internalAppIds", "", "printLogs", "", "printInternalLogs", "debug", "", "message", "info", "warning", "error", "", "internal", "printMessage", "impl_release"})
public final class RealPrivyLogger
implements PrivyLogger {
    @NotNull
    private final PrivyLogLevel level;
    @NotNull
    private final String appId;
    @NotNull
    private final List<String> internalAppIds;
    private final boolean printLogs;
    private final boolean printInternalLogs;

    public RealPrivyLogger(@NotNull PrivyLogLevel level, @NotNull String appId) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.level = level;
        this.appId = appId;
        Object[] objectArray = new String[]{"clpijy3tw0001kz0g6ixs9z15", "cla06f34x0001mh08l8nsr496"};
        this.internalAppIds = CollectionsKt.listOf((Object[])objectArray);
        this.printLogs = this.level != PrivyLogLevel.NONE;
        this.printInternalLogs = this.internalAppIds.contains(this.appId);
    }

    public void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level == PrivyLogLevel.DEBUG || this.level == PrivyLogLevel.VERBOSE) {
            this.printMessage(message);
        }
    }

    public void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level == PrivyLogLevel.INFO || this.level == PrivyLogLevel.VERBOSE) {
            this.printMessage(message);
        }
    }

    public void warning(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level == PrivyLogLevel.WARNING || this.level == PrivyLogLevel.VERBOSE) {
            this.printMessage(message);
        }
    }

    public void error(@NotNull String message, @Nullable Throwable error) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.level == PrivyLogLevel.ERROR || this.level == PrivyLogLevel.VERBOSE) {
            this.printMessage(message);
        }
    }

    public void internal(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.printInternalLogs && (this.level == PrivyLogLevel.ERROR || this.level == PrivyLogLevel.VERBOSE)) {
            this.printMessage("(Internal) " + message);
        }
    }

    private final void printMessage(String message) {
        if (this.printLogs) {
            System.out.println((Object)("Privy: " + message));
        }
    }
}

