package io.privy.logging

/**
 * The default PrivyLogger. Upon SDK initialization, client will pass in log level. Privy will only
 * print to std out if log level != NONE.
 */
public interface PrivyLogger {
  public fun debug(message: String)

  public fun info(message: String)

  public fun warning(message: String)

  public fun error(message: String, error: Throwable? = null)

  public fun internal(message: String)
}
