package io.privy.network

public sealed interface NetworkState {
  // When application doesn't have permissions to check network state
  public data object Unknown: NetworkState

  // If user's device is connected to network
  public data object Connected: NetworkState

  // If user's device is not connected to a network
  public data object Disconnected: NetworkState
}

// We specifically want to expose isDisconnected() instead of isConnected
// because if network state is Unknown, we don't want to consider it connected or disconnected
public fun NetworkState.isDisconnected(): Boolean {
  return this is NetworkState.Disconnected
}