package io.privy.network

public interface NetworkStateManager {
  /**
   * Returns user's network connectivity status
   *
   * @return [NetworkState] indicating device's network state.
   * Will return [NetworkState.Unknown] if proper permissions were not added to Android manifest.
   */
  public val current: NetworkState
}

public inline fun <reified R : Any> NetworkStateManager.ensureDeviceConnectedToInternet(
  block: () -> Result<R>
): Result<R> {
  return if (current.isDisconnected()) {
    Result.failure(
      Throwable("The device is not connected to the internet.")
    )
  } else {
    block()
  }
}