package io.privy.network

public sealed interface NetworkState {
  // When application doesn't have permissions to check network state
  public data object Unknown: NetworkState

  // If user's device is connected to network
  public data object Connected: NetworkState

  // If user's device is not connected to a network
  public data object Disconnected: NetworkState
}

// Note: Network is only considered disconnected if we can confirm it's disconnected.
// In the case where app developer doesn't include the ACCESS_NETWORK_STATE permission,
// we can't determine network state, and thus, it will is Unknown
// This helper method only returns true if we can confirm network state is disconnected.
public fun NetworkState.isConfirmedDisconnected(): Boolean {
  return this is NetworkState.Disconnected
}

// Note: Network is only considered connected if we can confirm it's connected.
// In the case where app developer doesn't include the ACCESS_NETWORK_STATE permission,
// we can't determine network state, and thus, it will is Unknown.
// This helper method only returns true if we can confirm network state is connected.
public fun NetworkState.isConfirmedConnected(): Boolean {
  return this is NetworkState.Connected
}