package io.privy.network

public enum class PrivyEnvironment {
  Staging,
  Production
}

/**
 * Gets the base URL for the Privy API based on the current environment.
 *
 * @return The base URL string for the current environment
 */
public fun PrivyEnvironment.baseUrl(): String {
  return when (this) {
    PrivyEnvironment.Staging -> STAGING_URL
    PrivyEnvironment.Production -> PRODUCTION_URL
  }
}

private const val PRODUCTION_URL = "https://auth.privy.io/api/v1/"
private const val STAGING_URL = "https://auth.staging.privy.io/api/v1/"
