package io.privy.sdk.di

import android.content.Context
import io.privy.auth.oAuth.OAuthHandler
import io.privy.auth.oAuth.PKCEHelper
import io.privy.di.KmpAppComponent
import io.privy.logging.PrivyLogLevel
import io.privy.network.PrivyEnvironment
import io.privy.network.PrivyInternalSettings
import io.privy.wallet.webview.WebViewHandler
import me.tatarka.inject.annotations.Component
import me.tatarka.inject.annotations.Provides

@Component
public abstract class PrivyCoreComponent(
    @get:Provides public val kmpComponent: KmpAppComponent,
    @get:Provides public val privyEnvironment: PrivyEnvironment,
    @get:Provides public val privyInternalSettings: PrivyInternalSettings?
) : PrivyCoreBindings {
  public companion object {
    public fun create(
        context: Context,
        privyAppId: String,
        privyAppClientId: String,
        privyLogLevel: PrivyLogLevel,
        appBundleIdentifier: String,
        webViewHandler: WebViewHandler,
        privyEnvironment: PrivyEnvironment,
        privyInternalSettings: PrivyInternalSettings?,
        pkceHelper: PKCEHelper,
        oAuthHandler: OAuthHandler
    ): PrivyCoreComponent {
      val kmpComponent =
          KmpAppComponent.create(
              context = context,
              privyAppId = privyAppId,
              privyAppClientId = privyAppClientId,
              privyLogLevel = privyLogLevel,
              appBundleIdentifier = appBundleIdentifier,
              webViewHandler = webViewHandler,
              privyEnvironment = privyEnvironment,
              privyInternalSettings = privyInternalSettings,
              pkceHelper = pkceHelper,
              oAuthHandler = oAuthHandler,
            )

      return PrivyCoreComponent::class.create(kmpComponent, privyEnvironment, privyInternalSettings)
    }
  }
}
