package io.privy.sdk

import android.content.Context
import io.privy.auth.AuthState
import io.privy.auth.PrivyUser
import io.privy.auth.customAuth.LoginWithCustomAuth
import io.privy.auth.email.LoginWithEmail
import io.privy.auth.sms.LoginWithSms
import io.privy.wallet.EmbeddedWalletManager
import kotlinx.coroutines.flow.StateFlow

public interface Privy {
  // Check if Privy is ready to be used
  public val isReady: Boolean

  /**
   * The privy user object. Will be non null if the user is authenticated.
   * Be sure to check Privy.isReady before accessing the user.
   */
  public val user: PrivyUser?

  // A state flow that can be subscribed to for auth state updates
  public val authState: StateFlow<AuthState>

  // Entry point for SMS auth
  public val sms: LoginWithSms

  // Entry point for Email auth
  public val email: LoginWithEmail

  // Entry point for third-party auth sign in
  public val customAuth: LoginWithCustomAuth

  // Entry point for embedded wallet flow
  // public val embeddedWallet: EmbeddedWalletManager

  // Suspend execution until Privy is ready
  public suspend fun awaitReady()

  public suspend fun refreshSession()

  public suspend fun logout()

  public companion object {
    public fun init(context: Context, config: PrivyConfig): Privy {
      return PrivyImpl(
        context = context,
        config = config,
      )
    }
  }
}




