package io.privy.sdk.webview

import android.util.Log
import android.webkit.JavascriptInterface

/**
 * When Privy JS app (loaded in the iframe) calls AndroidProxy.postMessage
 * It will be received here.
 */
internal class PrivyJavascriptInterface(
  private val onMessageReceived: (String) -> Unit
) {
  // Important - this method MUST be named "postMessage" because that is the name of the
  // function JS calls
  @JavascriptInterface
  fun postMessage(message: String) {
    Log.d("WebViewMessage", "Message from JS: $message")
    onMessageReceived(message)
  }
}