package io.privy.sdk.webview

import kotlinx.coroutines.sync.Mutex
import kotlinx.coroutines.sync.withLock
import kotlinx.coroutines.yield

internal class WebViewState {
  private var isReady = false

  // Use a mutex to ensure thread-safe access
  private val mutex = Mutex()

  suspend fun isReady(): Boolean {
    mutex.withLock { // Lock for exclusive access
      return isReady
    }
  }

  suspend fun setReady(ready: Boolean) {
    mutex.withLock { // Lock for exclusive access
      isReady = ready
    }
  }

  suspend fun awaitReady() {
    // Use a while loop with yield() to avoid busy waiting
    while (!isReady) {
      yield() // Allow other coroutines to run
    }
  }
}