package io.privy.sdk

import io.privy.auth.customAuth.TokenProvider
import io.privy.logging.PrivyLogLevel

/**
 * Configuration when initializing the PrivySDK.
 *
 * @param appId Unique ID for your application, can be retrieved from the developer dashboard @
 *   `https://console.privy.io/apps/<your-app-id>/settings`
 * @param appClientId Unique ID for your application client, can be retrieved from the developer
 *   dashboard @ `https://console.privy.io/apps/<your-app-id>/settings?setting=clients`
 * @param logLevel Specifies Privy log levels. Should be set to NONE for production builds.
 * @param customAuthConfig Required if authenticating via third party auth.
 */
public data class PrivyConfig(
    public val appId: String,
    public val appClientId: String,
    public val logLevel: PrivyLogLevel,
    public val customAuthConfig: LoginWithCustomAuthConfig? = null
)

/**
 * The configuration for third party auth. Required if using third part auth as your login method.
 *
 * @param tokenProvider Provides Privy a hook to retrieve the access token from your third party
 *   authentication provider. This callback will be invoked when
 *   [Privy.customAuth.loginWithCustomAccessToken] is called, when attempting to restore a prior
 *   session, or when refreshing a session.
 */
public data class LoginWithCustomAuthConfig(public val tokenProvider: TokenProvider)

public typealias TokenProvider = suspend () -> String?
