package io.privy.sdk.internal

import io.privy.network.PrivyInternalSettings

public object PrivyInternal {
  private val SECRET_KEY = "caba52bb-499e-4034-aaa6-bb4fbcdee175"

  private var settings: PrivyInternalSettings? = null

  // Internal access for PrivyImpl
  internal val internalSettings: PrivyInternalSettings?
    get() = settings

  // Public method for external platform to call via platform channel
  public fun setInternalConfig(platform: String, sdkVersion: String, secretKey: String) {
    if (secretKey == SECRET_KEY) {
      settings = PrivyInternalSettings(platform, sdkVersion)
    } else {
      // Silently fails if secret key is incorrect
      return
    }
  }
}
