/*
 * Decompiled with CFR 0.152.
 */
package io.privy.sdk.oAuth;

import io.privy.auth.oAuth.PKCEHelper;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\n"}, d2={"Lio/privy/sdk/oAuth/RealPKCEHelper;", "Lio/privy/auth/oAuth/PKCEHelper;", "<init>", "()V", "generateCodeVerifier", "", "generateStateCode", "deriveCodeChallenge", "codeVerifier", "Companion", "sdk_release"})
public final class RealPKCEHelper
implements PKCEHelper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Deprecated
    public static final int CODE_VERIFIER_BYTE_LENGTH = 32;

    @NotNull
    public String generateCodeVerifier() {
        byte[] randomBytes = new byte[32];
        new SecureRandom().nextBytes(randomBytes);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(randomBytes);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @NotNull
    public String generateStateCode() {
        return this.generateCodeVerifier();
    }

    @NotNull
    public String deriveCodeChallenge(@NotNull String codeVerifier) {
        Intrinsics.checkNotNullParameter((Object)codeVerifier, (String)"codeVerifier");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        byte[] byArray = codeVerifier.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] digest = messageDigest.digest(byArray);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(digest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/privy/sdk/oAuth/RealPKCEHelper$Companion;", "", "<init>", "()V", "CODE_VERIFIER_BYTE_LENGTH", "", "sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

