/*
 * Decompiled with CFR 0.152.
 */
package io.privy.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.util.Log;
import io.privy.logging.PrivyLogLevel;
import io.privy.network.NetworkState;
import io.privy.network.NetworkStateManager;
import io.privy.sdk.network.RealNetworkStateManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000G\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0010\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u0013*\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\tH\u0002J\u0016\u0010\u0017\u001a\u00020\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0011\u00a8\u0006\u001c"}, d2={"Lio/privy/sdk/network/RealNetworkStateManager;", "Lio/privy/network/NetworkStateManager;", "context", "Landroid/content/Context;", "logLevel", "Lio/privy/logging/PrivyLogLevel;", "<init>", "(Landroid/content/Context;Lio/privy/logging/PrivyLogLevel;)V", "current", "Lio/privy/network/NetworkState;", "getCurrent", "()Lio/privy/network/NetworkState;", "_currentState", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkCallback", "io/privy/sdk/network/RealNetworkStateManager$networkCallback$1", "Lio/privy/sdk/network/RealNetworkStateManager$networkCallback$1;", "setupConnectivity", "", "updateState", "Landroid/net/NetworkCapabilities;", "newState", "printLog", "log", "Lkotlin/Function0;", "hasAccessNetworkStatePermission", "", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RealNetworkStateManager
implements NetworkStateManager {
    @NotNull
    private final Context context;
    @NotNull
    private final PrivyLogLevel logLevel;
    @NotNull
    private NetworkState _currentState;
    @NotNull
    private ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback;

    public RealNetworkStateManager(@NotNull Context context, @NotNull PrivyLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.context = context;
        this.logLevel = logLevel;
        this._currentState = (NetworkState)NetworkState.Unknown.INSTANCE;
        Object object = this.context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ RealNetworkStateManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Connected.INSTANCE);
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Disconnected.INSTANCE);
            }

            public void onUnavailable() {
                super.onUnavailable();
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Disconnected.INSTANCE);
            }

            public void onCapabilitiesChanged(Network network, NetworkCapabilities networkCapabilities) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                Intrinsics.checkNotNullParameter((Object)networkCapabilities, (String)"networkCapabilities");
                super.onCapabilitiesChanged(network, networkCapabilities);
                RealNetworkStateManager.access$updateState(this.this$0, networkCapabilities);
            }
        };
        try {
            if (this.hasAccessNetworkStatePermission()) {
                this.setupConnectivity();
            } else {
                this.printLog((Function0<Unit>)((Function0)RealNetworkStateManager::_init_$lambda$0));
            }
        }
        catch (SecurityException e) {
            this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager._init_$lambda$1(e)));
        }
    }

    @NotNull
    public NetworkState getCurrent() {
        return this._currentState;
    }

    private final void setupConnectivity() {
        block6: {
            block5: {
                Unit unit;
                NetworkCapabilities networkCapabilities;
                Network network = this.connectivityManager.getActiveNetwork();
                if (network == null) break block5;
                Network activeNetwork = network;
                boolean bl = false;
                NetworkCapabilities networkCapabilities2 = networkCapabilities = this.connectivityManager.getNetworkCapabilities(activeNetwork);
                if (networkCapabilities2 != null) {
                    this.updateState(networkCapabilities2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block6;
            }
            boolean bl = false;
            this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
        }
        this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    private final void updateState(NetworkCapabilities $this$updateState) {
        if ($this$updateState != null) {
            boolean isConnected = $this$updateState.hasCapability(16);
            if (isConnected) {
                this.updateState((NetworkState)NetworkState.Connected.INSTANCE);
            } else {
                this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
            }
        } else {
            this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
        }
    }

    private final void updateState(NetworkState newState) {
        if (!Intrinsics.areEqual((Object)newState, (Object)this._currentState)) {
            this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager.updateState$lambda$4(this, newState)));
            this._currentState = newState;
        }
    }

    private final void printLog(Function0<Unit> log) {
        if (this.logLevel != PrivyLogLevel.NONE) {
            log.invoke();
        }
    }

    private final boolean hasAccessNetworkStatePermission() {
        return this.context.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
    }

    private static final Unit _init_$lambda$0() {
        Log.i((String)"PrivyNetwork", (String)"Please add the android.permission.ACCESS_NETWORK_STATE permission to your AndroidManifest to allow Privy to determine the device's network state.");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(SecurityException $e) {
        Log.e((String)"PrivyNetwork", (String)("NetworkStateManager threw Security exception. " + $e.getMessage()));
        return Unit.INSTANCE;
    }

    private static final Unit updateState$lambda$4(RealNetworkStateManager this$0, NetworkState $newState) {
        Log.v((String)"PrivyNetwork", (String)("Device network has changed from: " + this$0._currentState + " to " + $newState + "."));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$updateState(RealNetworkStateManager $this, NetworkState newState) {
        $this.updateState(newState);
    }

    public static final /* synthetic */ void access$updateState(RealNetworkStateManager $this, NetworkCapabilities $receiver) {
        $this.updateState($receiver);
    }
}

