package io.privy.sdk.internal

import io.privy.network.PrivyInternalSettings

public object PrivyInternal {
  private const val KEY_PLATFORM = "platform"
  private const val KEY_VERSION = "version"
  private const val KEY_SECRET = "secret"
  private const val EXPECTED_SECRET = "caba52bb-499e-4034-aaa6-bb4fbcdee175"

  private var settings: PrivyInternalSettings? = null

  // Internal access for PrivyImpl
  internal val internalSettings: PrivyInternalSettings?
    get() = settings

  // Public method for external platform to call via platform channel
  public fun setConfig(config: Map<String, String>) {
    val secret = config[KEY_SECRET]

    if (secret != EXPECTED_SECRET) {
      // Silently fails if secret key is incorrect
      return
    }

    val platform = config[KEY_PLATFORM]
    val version = config[KEY_VERSION]

    if (platform != null && version != null) {
      settings = PrivyInternalSettings(platform, version)
    }
  }
}
