package io.privy.sdk.oAuth

import android.content.Context
import android.content.Intent
import io.privy.auth.oAuth.OAuthHandler
import me.tatarka.inject.annotations.Inject

/**
 * Implementation of the OAuthHandler interface that manages OAuth authentication flows. This class
 * handles the OAuth authorization process, including generating authorization URLs, launching
 * browser tabs for authentication, and processing redirect URLs.
 */
@Inject
public class RealOAuthHandler(private val context: Context) : OAuthHandler {

  /**
   * Opens the authentication URL in a Chrome Custom Tab with launcher activity. This enables
   * detection of when the user closes the tab without completing OAuth.
   *
   * @param authUrl The authentication URL to open
   * @return Result indicating success or failure of launching the browser
   */
  public override fun launchCustomTab(authUrl: String) {
    val launcherIntent =
        Intent(context, PrivyRedirectActivity::class.java).apply {
          addFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
          putExtra("url", authUrl)
        }

    context.startActivity(launcherIntent)
  }
}
