/*
 * Decompiled with CFR 0.152.
 */
package io.privy.sdk;

import android.content.Context;
import io.privy.analytics.AnalyticsEvent;
import io.privy.auth.AuthState;
import io.privy.auth.PrivyAuth;
import io.privy.auth.PrivyUser;
import io.privy.auth.customAuth.LoginWithCustomAuth;
import io.privy.auth.email.LoginWithEmail;
import io.privy.auth.oAuth.LoginWithOAuth;
import io.privy.auth.oAuth.OAuthHandler;
import io.privy.auth.oAuth.PKCEHelper;
import io.privy.auth.siwe.LoginWithSiwe;
import io.privy.auth.sms.LoginWithSms;
import io.privy.logging.PrivyLogLevel;
import io.privy.network.NetworkStateManager;
import io.privy.network.PrivyEnvironment;
import io.privy.network.PrivyInternalSettings;
import io.privy.sdk.Privy;
import io.privy.sdk.PrivyConfig;
import io.privy.sdk.PrivyImplKt;
import io.privy.sdk.di.PrivyCoreComponent;
import io.privy.sdk.internal.PrivyInternal;
import io.privy.sdk.network.RealNetworkStateManager;
import io.privy.sdk.oAuth.RealOAuthHandler;
import io.privy.sdk.oAuth.RealPKCEHelper;
import io.privy.sdk.webview.RealWebViewHandler;
import io.privy.wallet.webview.WebViewHandler;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010(\u001a\u00020'H\u0096@\u00a2\u0006\u0002\u0010>J\u000e\u0010?\u001a\u00020@H\u0096@\u00a2\u0006\u0002\u0010>J\u000e\u0010A\u001a\u00020\u001dH\u0096@\u00a2\u0006\u0002\u0010>J\u000e\u0010B\u001a\u00020@H\u0096@\u00a2\u0006\u0002\u0010>J\u000e\u0010C\u001a\u00020@H\u0096@\u00a2\u0006\u0002\u0010>J\b\u0010D\u001a\u00020@H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001d8VX\u0097\u0004\u00a2\u0006\f\u0012\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u000203X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0014\u00106\u001a\u000207X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0014\u0010:\u001a\u00020;X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=\u00a8\u0006E"}, d2={"Lio/privy/sdk/PrivyImpl;", "Lio/privy/sdk/Privy;", "context", "Landroid/content/Context;", "config", "Lio/privy/sdk/PrivyConfig;", "<init>", "(Landroid/content/Context;Lio/privy/sdk/PrivyConfig;)V", "scope", "Lkotlinx/coroutines/CoroutineScope;", "privyEnvironment", "Lio/privy/network/PrivyEnvironment;", "networkStateManager", "Lio/privy/sdk/network/RealNetworkStateManager;", "getNetworkStateManager", "()Lio/privy/sdk/network/RealNetworkStateManager;", "webViewHandler", "Lio/privy/sdk/webview/RealWebViewHandler;", "pkceHelper", "Lio/privy/sdk/oAuth/RealPKCEHelper;", "oAuthHandler", "Lio/privy/sdk/oAuth/RealOAuthHandler;", "privyInternalSettings", "Lio/privy/network/PrivyInternalSettings;", "coreComponent", "Lio/privy/sdk/di/PrivyCoreComponent;", "auth", "Lio/privy/auth/PrivyAuth;", "isReady", "", "isReady$annotations", "()V", "()Z", "user", "Lio/privy/auth/PrivyUser;", "getUser", "()Lio/privy/auth/PrivyUser;", "authState", "Lkotlinx/coroutines/flow/StateFlow;", "Lio/privy/auth/AuthState;", "getAuthState", "()Lkotlinx/coroutines/flow/StateFlow;", "sms", "Lio/privy/auth/sms/LoginWithSms;", "getSms", "()Lio/privy/auth/sms/LoginWithSms;", "email", "Lio/privy/auth/email/LoginWithEmail;", "getEmail", "()Lio/privy/auth/email/LoginWithEmail;", "customAuth", "Lio/privy/auth/customAuth/LoginWithCustomAuth;", "getCustomAuth", "()Lio/privy/auth/customAuth/LoginWithCustomAuth;", "siwe", "Lio/privy/auth/siwe/LoginWithSiwe;", "getSiwe", "()Lio/privy/auth/siwe/LoginWithSiwe;", "oAuth", "Lio/privy/auth/oAuth/LoginWithOAuth;", "getOAuth", "()Lio/privy/auth/oAuth/LoginWithOAuth;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitReady", "", "hasPersistedAuthCredentials", "onNetworkRestored", "logout", "logSdkInitializeEvent", "sdk_release"})
public final class PrivyImpl
implements Privy {
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final PrivyEnvironment privyEnvironment;
    @NotNull
    private final RealNetworkStateManager networkStateManager;
    @NotNull
    private final RealWebViewHandler webViewHandler;
    @NotNull
    private final RealPKCEHelper pkceHelper;
    @NotNull
    private final RealOAuthHandler oAuthHandler;
    @Nullable
    private final PrivyInternalSettings privyInternalSettings;
    @NotNull
    private final PrivyCoreComponent coreComponent;
    @NotNull
    private final PrivyAuth auth;
    @NotNull
    private final StateFlow<AuthState> authState;
    @NotNull
    private final LoginWithSms sms;
    @NotNull
    private final LoginWithEmail email;
    @NotNull
    private final LoginWithCustomAuth customAuth;
    @NotNull
    private final LoginWithSiwe siwe;
    @NotNull
    private final LoginWithOAuth oAuth;

    public PrivyImpl(@NotNull Context context, @NotNull PrivyConfig config) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null).plus((CoroutineContext)Dispatchers.getMain().getImmediate()));
        this.privyEnvironment = PrivyImplKt.access$getStagingAppIds$p().contains(config.getAppId()) ? PrivyEnvironment.Staging : PrivyEnvironment.Production;
        this.networkStateManager = new RealNetworkStateManager(context, config.getLogLevel());
        this.webViewHandler = new RealWebViewHandler(context, this.privyEnvironment, config.getAppId(), config.getAppClientId(), config.getLogLevel(), this.getNetworkStateManager());
        this.pkceHelper = new RealPKCEHelper();
        this.oAuthHandler = new RealOAuthHandler(context);
        this.privyInternalSettings = PrivyInternal.INSTANCE.getInternalSettings$sdk_release();
        String string = config.getAppId();
        String string2 = config.getAppClientId();
        PrivyLogLevel privyLogLevel = config.getLogLevel();
        String string3 = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPackageName(...)");
        this.coreComponent = PrivyCoreComponent.Companion.create(context, string, string2, privyLogLevel, string3, (WebViewHandler)this.webViewHandler, this.privyEnvironment, this.privyInternalSettings, (NetworkStateManager)this.getNetworkStateManager(), (PKCEHelper)this.pkceHelper, (OAuthHandler)this.oAuthHandler);
        this.auth = this.coreComponent.getKmpComponent().getAuth();
        this.authState = this.auth.getAuthStateUpdates();
        this.sms = this.auth.getSms();
        this.email = this.auth.getEmail();
        this.customAuth = this.auth.getCustomAuth();
        this.siwe = this.auth.getSiwe();
        this.oAuth = this.auth.getOAuth();
        if (config.getCustomAuthConfig() != null) {
            this.getCustomAuth().setTokenProvider(config.getCustomAuthConfig().getTokenProvider());
        }
        this.logSdkInitializeEvent();
    }

    @Override
    @NotNull
    public RealNetworkStateManager getNetworkStateManager() {
        return this.networkStateManager;
    }

    @Override
    public boolean isReady() {
        return this.auth.isReady();
    }

    @Deprecated(message="It's no longer required to check ready state prior to checking the user's AuthState anymore. Instead, users should use \"suspend fun getAuthState(): AuthState\"")
    public static /* synthetic */ void isReady$annotations() {
    }

    @Override
    @Nullable
    public PrivyUser getUser() {
        return this.auth.getUser();
    }

    @Override
    @NotNull
    public StateFlow<AuthState> getAuthState() {
        return this.authState;
    }

    @Override
    @NotNull
    public LoginWithSms getSms() {
        return this.sms;
    }

    @Override
    @NotNull
    public LoginWithEmail getEmail() {
        return this.email;
    }

    @Override
    @NotNull
    public LoginWithCustomAuth getCustomAuth() {
        return this.customAuth;
    }

    @Override
    @NotNull
    public LoginWithSiwe getSiwe() {
        return this.siwe;
    }

    @Override
    @NotNull
    public LoginWithOAuth getOAuth() {
        return this.oAuth;
    }

    @Override
    @Nullable
    public Object getAuthState(@NotNull Continuation<? super AuthState> $completion) {
        return this.auth.getAuthState($completion);
    }

    @Override
    @Nullable
    public Object awaitReady(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.auth.awaitInitializationComplete($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object hasPersistedAuthCredentials(@NotNull Continuation<? super Boolean> $completion) {
        return this.auth.hasPersistedAuthCredentials($completion);
    }

    @Override
    @Nullable
    public Object onNetworkRestored(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.auth.onNetworkRestored($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object logout(@NotNull Continuation<? super Unit> $completion) {
        Object object = this.auth.logout($completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void logSdkInitializeEvent() {
        BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PrivyImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PrivyImpl.access$getCoreComponent$p(this.this$0).getKmpComponent().getAnalyticsManager().logEvent((AnalyticsEvent)AnalyticsEvent.SdkInitialize.INSTANCE, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public static final /* synthetic */ PrivyCoreComponent access$getCoreComponent$p(PrivyImpl $this) {
        return $this.coreComponent;
    }
}

