/*
 * Decompiled with CFR 0.152.
 */
package io.privy.sdk.network;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.util.Log;
import io.privy.logging.PrivyLogLevel;
import io.privy.network.NetworkState;
import io.privy.network.NetworkStateKt;
import io.privy.network.NetworkStateManager;
import io.privy.sdk.network.RealNetworkStateManager;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000*\u0001\u0016\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0016J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\fH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0002J\u000e\u0010\u0019\u001a\u00020\u000e*\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0016\u0010\u001c\u001a\u00020\u000e2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006!"}, d2={"Lio/privy/sdk/network/RealNetworkStateManager;", "Lio/privy/network/NetworkStateManager;", "context", "Landroid/content/Context;", "logLevel", "Lio/privy/logging/PrivyLogLevel;", "<init>", "(Landroid/content/Context;Lio/privy/logging/PrivyLogLevel;)V", "_networkState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lio/privy/network/NetworkState;", "observeNetworkChanges", "Lkotlinx/coroutines/flow/Flow;", "observeNetworkRestored", "", "_current", "current", "getCurrent", "()Lio/privy/network/NetworkState;", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkCallback", "io/privy/sdk/network/RealNetworkStateManager$networkCallback$1", "Lio/privy/sdk/network/RealNetworkStateManager$networkCallback$1;", "setupConnectivity", "updateState", "Landroid/net/NetworkCapabilities;", "newState", "printLog", "log", "Lkotlin/Function0;", "hasAccessNetworkStatePermission", "", "sdk_release"})
@SuppressLint(value={"MissingPermission"})
public final class RealNetworkStateManager
implements NetworkStateManager {
    @NotNull
    private final Context context;
    @NotNull
    private final PrivyLogLevel logLevel;
    @NotNull
    private MutableStateFlow<NetworkState> _networkState;
    @NotNull
    private NetworkState _current;
    @NotNull
    private ConnectivityManager connectivityManager;
    @NotNull
    private final networkCallback.1 networkCallback;

    public RealNetworkStateManager(@NotNull Context context, @NotNull PrivyLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        this.context = context;
        this.logLevel = logLevel;
        this._networkState = StateFlowKt.MutableStateFlow((Object)NetworkState.Unknown.INSTANCE);
        this._current = (NetworkState)NetworkState.Unknown.INSTANCE;
        Object object = this.context.getSystemService("connectivity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.net.ConnectivityManager");
        this.connectivityManager = (ConnectivityManager)object;
        this.networkCallback = new ConnectivityManager.NetworkCallback(this){
            final /* synthetic */ RealNetworkStateManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAvailable(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onAvailable(network);
                RealNetworkStateManager.access$printLog(this.this$0, networkCallback.1::onAvailable$lambda$0);
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Connected.INSTANCE);
            }

            public void onLost(Network network) {
                Intrinsics.checkNotNullParameter((Object)network, (String)"network");
                super.onLost(network);
                RealNetworkStateManager.access$printLog(this.this$0, networkCallback.1::onLost$lambda$1);
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Disconnected.INSTANCE);
            }

            public void onUnavailable() {
                super.onUnavailable();
                RealNetworkStateManager.access$printLog(this.this$0, networkCallback.1::onUnavailable$lambda$2);
                RealNetworkStateManager.access$updateState(this.this$0, (NetworkState)NetworkState.Disconnected.INSTANCE);
            }

            private static final Unit onAvailable$lambda$0() {
                Log.v((String)"Privy", (String)"Network onAvailable");
                return Unit.INSTANCE;
            }

            private static final Unit onLost$lambda$1() {
                Log.v((String)"Privy", (String)"Network onLost");
                return Unit.INSTANCE;
            }

            private static final Unit onUnavailable$lambda$2() {
                Log.v((String)"Privy", (String)"Network onUnavailable");
                return Unit.INSTANCE;
            }
        };
        try {
            if (this.hasAccessNetworkStatePermission()) {
                this.setupConnectivity();
            } else {
                this.printLog((Function0<Unit>)((Function0)RealNetworkStateManager::_init_$lambda$0));
            }
        }
        catch (SecurityException e) {
            this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager._init_$lambda$1(e)));
        }
    }

    @NotNull
    public Flow<NetworkState> observeNetworkChanges() {
        return (Flow)FlowKt.asSharedFlow((MutableSharedFlow)((MutableSharedFlow)this._networkState));
    }

    @NotNull
    public Flow<Unit> observeNetworkRestored() {
        return FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super Unit>, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RealNetworkStateManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        FlowCollector $this$flow = (FlowCollector)this.L$0;
                        this.label = 1;
                        Object object3 = FlowKt.reduce((Flow)((Flow)RealNetworkStateManager.access$get_networkState$p(this.this$0)), (Function3)((Function3)new Function3<NetworkState, NetworkState, Continuation<? super NetworkState>, Object>((FlowCollector<? super Unit>)$this$flow, null){
                            int label;
                            /* synthetic */ Object L$0;
                            /* synthetic */ Object L$1;
                            final /* synthetic */ FlowCollector<Unit> $$this$flow;
                            {
                                this.$$this$flow = $$this$flow;
                                super(3, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        NetworkState oldState = (NetworkState)this.L$0;
                                        NetworkState newState = (NetworkState)this.L$1;
                                        if (NetworkStateKt.isConfirmedConnected((NetworkState)oldState) || !NetworkStateKt.isConfirmedConnected((NetworkState)newState)) return newState;
                                        this.L$0 = newState;
                                        this.label = 1;
                                        Object object3 = this.$$this$flow.emit((Object)Unit.INSTANCE, (Continuation)this);
                                        if (object3 != object2) return newState;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        NetworkState newState = (NetworkState)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return newState;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Object invoke(NetworkState p1, NetworkState p2, Continuation<? super NetworkState> p3) {
                                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                                var4_4.L$0 = p1;
                                var4_4.L$1 = p2;
                                return var4_4.invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(FlowCollector<? super Unit> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @NotNull
    public NetworkState getCurrent() {
        return this._current;
    }

    private final void setupConnectivity() {
        block6: {
            block5: {
                Unit unit;
                NetworkCapabilities networkCapabilities;
                Network network = this.connectivityManager.getActiveNetwork();
                if (network == null) break block5;
                Network activeNetwork = network;
                boolean bl = false;
                NetworkCapabilities networkCapabilities2 = networkCapabilities = this.connectivityManager.getNetworkCapabilities(activeNetwork);
                if (networkCapabilities2 != null) {
                    this.updateState(networkCapabilities2);
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) break block6;
            }
            boolean bl = false;
            this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
        }
        this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager.setupConnectivity$lambda$4(this)));
        this.connectivityManager.registerDefaultNetworkCallback((ConnectivityManager.NetworkCallback)this.networkCallback);
    }

    private final void updateState(NetworkCapabilities $this$updateState) {
        if ($this$updateState != null) {
            boolean isConnected = $this$updateState.hasCapability(16);
            if (isConnected) {
                this.updateState((NetworkState)NetworkState.Connected.INSTANCE);
            } else {
                this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
            }
        } else {
            this.updateState((NetworkState)NetworkState.Disconnected.INSTANCE);
        }
    }

    private final void updateState(NetworkState newState) {
        if (!Intrinsics.areEqual((Object)newState, (Object)this._networkState.getValue())) {
            this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager.updateState$lambda$5(this, newState)));
            this._current = newState;
            this.printLog((Function0<Unit>)((Function0)() -> RealNetworkStateManager.updateState$lambda$6(this)));
            this._networkState.setValue((Object)newState);
        }
    }

    private final void printLog(Function0<Unit> log) {
        if (this.logLevel != PrivyLogLevel.NONE) {
            log.invoke();
        }
    }

    private final boolean hasAccessNetworkStatePermission() {
        return this.context.checkSelfPermission("android.permission.ACCESS_NETWORK_STATE") == 0;
    }

    private static final Unit _init_$lambda$0() {
        Log.i((String)"Privy", (String)"Please add the android.permission.ACCESS_NETWORK_STATE permission to your AndroidManifest to allow Privy to determine the device's network state.");
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(SecurityException $e) {
        Log.e((String)"Privy", (String)("NetworkStateManager threw Security exception. " + $e.getMessage()));
        return Unit.INSTANCE;
    }

    private static final Unit setupConnectivity$lambda$4(RealNetworkStateManager this$0) {
        Log.v((String)"Privy", (String)("Initial network state: " + this$0._networkState.getValue()));
        return Unit.INSTANCE;
    }

    private static final Unit updateState$lambda$5(RealNetworkStateManager this$0, NetworkState $newState) {
        Log.v((String)"Privy", (String)("Device network has changed from: " + this$0._networkState.getValue() + " to " + $newState + "."));
        return Unit.INSTANCE;
    }

    private static final Unit updateState$lambda$6(RealNetworkStateManager this$0) {
        Log.v((String)"Privy", (String)("Updating current network state: " + this$0._current + "."));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MutableStateFlow access$get_networkState$p(RealNetworkStateManager $this) {
        return $this._networkState;
    }

    public static final /* synthetic */ void access$printLog(RealNetworkStateManager $this, Function0 log) {
        $this.printLog((Function0<Unit>)log);
    }

    public static final /* synthetic */ void access$updateState(RealNetworkStateManager $this, NetworkState newState) {
        $this.updateState(newState);
    }
}

