/*
 * Decompiled with CFR 0.152.
 */
package io.privy.sdk.oAuth;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import androidx.activity.ComponentActivity;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.browser.customtabs.CustomTabsIntent;
import io.privy.auth.AuthenticationException;
import io.privy.auth.oAuth.OAuthDataManager;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\u001b\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0012H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lio/privy/sdk/oAuth/PrivyRedirectActivity;", "Landroidx/activity/ComponentActivity;", "<init>", "()V", "customTabLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/content/Intent;", "isOAuthCompleted", "", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "intent", "handleCustomTabResult", "result", "Lkotlin/Result;", "", "(Ljava/lang/Object;)V", "launchCustomTab", "oauthUrl", "sdk_release"})
@SourceDebugExtension(value={"SMAP\nPrivyRedirectActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrivyRedirectActivity.kt\nio/privy/sdk/oAuth/PrivyRedirectActivity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Uri.kt\nandroidx/core/net/UriKt\n*L\n1#1,82:1\n1#2:83\n29#3:84\n*S KotlinDebug\n*F\n+ 1 PrivyRedirectActivity.kt\nio/privy/sdk/oAuth/PrivyRedirectActivity\n*L\n72#1:84\n*E\n"})
public final class PrivyRedirectActivity
extends ComponentActivity {
    private ActivityResultLauncher<Intent> customTabLauncher;
    private boolean isOAuthCompleted;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.customTabLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.StartActivityForResult(), arg_0 -> PrivyRedirectActivity.onCreate$lambda$1(this, arg_0));
        String oauthUrl = this.getIntent().getStringExtra("url");
        if (oauthUrl == null) {
            this.handleCustomTabResult(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new AuthenticationException("OAuth URL not provided")))));
            return;
        }
        this.launchCustomTab(oauthUrl);
    }

    protected void onNewIntent(@NotNull Intent intent) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
            super.onNewIntent(intent);
            Uri uri = intent.getData();
            if (uri == null) break block0;
            Uri redirectUri = uri;
            boolean bl = false;
            Log.d((String)"PrivyRedirectActivity", (String)("Received OAuth redirect: " + redirectUri));
            this.handleCustomTabResult(Result.constructor-impl((Object)redirectUri.toString()));
        }
    }

    private final void handleCustomTabResult(Object result) {
        if (!this.isOAuthCompleted) {
            this.isOAuthCompleted = true;
            OAuthDataManager.INSTANCE.handleCustomTabResult(result);
            this.finish();
        }
    }

    private final void launchCustomTab(String oauthUrl) {
        try {
            Intent intent;
            CustomTabsIntent customTabsIntent = new CustomTabsIntent.Builder().setShowTitle(true).build();
            Intrinsics.checkNotNullExpressionValue((Object)customTabsIntent, (String)"build(...)");
            CustomTabsIntent customTabsIntent2 = customTabsIntent;
            Intent $this$launchCustomTab_u24lambda_u243 = intent = customTabsIntent2.intent;
            boolean bl = false;
            String $this$toUri$iv = oauthUrl;
            boolean $i$f$toUri = false;
            $this$launchCustomTab_u24lambda_u243.setData(Uri.parse((String)$this$toUri$iv));
            Intent intent2 = intent;
            Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"apply(...)");
            Intent intent3 = intent2;
            ActivityResultLauncher<Intent> activityResultLauncher = this.customTabLauncher;
            if (activityResultLauncher == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"customTabLauncher");
                activityResultLauncher = null;
            }
            activityResultLauncher.launch((Object)intent3);
            Log.d((String)"PrivyRedirectActivity", (String)"Chrome Custom Tab launched with registerForActivityResult");
        }
        catch (Exception e) {
            Log.e((String)"PrivyRedirectActivity", (String)"Failed to launch Chrome Custom Tab", (Throwable)e);
            this.handleCustomTabResult(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)e)));
        }
    }

    private static final void onCreate$lambda$1$lambda$0(PrivyRedirectActivity this$0) {
        if (!this$0.isOAuthCompleted && !this$0.isFinishing()) {
            Log.d((String)"PrivyRedirectActivity", (String)"Chrome tab closed by user without completing OAuth");
            this$0.handleCustomTabResult(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)((Throwable)new AuthenticationException("OAuth flow cancelled by user")))));
        }
    }

    private static final void onCreate$lambda$1(PrivyRedirectActivity this$0, ActivityResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.getWindow().getDecorView().post(() -> PrivyRedirectActivity.onCreate$lambda$1$lambda$0(this$0));
    }
}

