/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.dependency;

import io.probedock.junitee.dependency.DependencyInjectionException;
import io.probedock.junitee.dependency.DependencyInjectorHelper;
import io.probedock.junitee.dependency.UseMock;
import io.probedock.junitee.generator.InjectDataGenerator;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.ejb.EJB;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

public class DependencyInjector {
    private DependencyInjector() {
    }

    public static void inject(Object obj, EntityManager em, boolean injectGenerators) {
        DependencyInjector.inject(obj.getClass(), obj, em, new HashMap<String, Object>(), new HashMap<String, Object>(), new HashSet<String>(), obj.getClass().getSimpleName(), injectGenerators);
    }

    private static void inject(Class cl, Object obj, EntityManager em, Map<String, Object> mockRegistry, Map<String, Object> ejbRegistry, Set<String> dgRegistry, String path, boolean injectGenerators) {
        if (cl.getSuperclass() != Object.class) {
            DependencyInjector.inject(cl.getSuperclass(), cl.getSuperclass().cast(obj), em, mockRegistry, ejbRegistry, dgRegistry, path, injectGenerators);
        }
        for (Field declaredField : cl.getDeclaredFields()) {
            try {
                if (!DependencyInjectorHelper.isNull(declaredField, obj)) continue;
                Object declaredFieldObjectInstantiated = null;
                if (declaredField.getAnnotation(UseMock.class) != null) {
                    for (Class<?> mockClass : declaredField.getAnnotation(UseMock.class).value()) {
                        DependencyInjectorHelper.instantiateMock(mockClass, mockRegistry);
                    }
                }
                if (declaredField.getAnnotation(EJB.class) != null) {
                    declaredFieldObjectInstantiated = DependencyInjectorHelper.instantiateEjb(declaredField, mockRegistry, ejbRegistry);
                } else if (injectGenerators && declaredField.isAnnotationPresent(InjectDataGenerator.class)) {
                    declaredFieldObjectInstantiated = DependencyInjectorHelper.instantiateDataGenerator(declaredField, path, dgRegistry);
                } else if (declaredField.isAnnotationPresent(PersistenceContext.class)) {
                    DependencyInjectorHelper.injectField(declaredField, obj, em);
                }
                if (declaredFieldObjectInstantiated == null) continue;
                DependencyInjectorHelper.injectField(declaredField, obj, declaredFieldObjectInstantiated);
                DependencyInjector.inject(declaredFieldObjectInstantiated.getClass(), declaredFieldObjectInstantiated, em, mockRegistry, ejbRegistry, dgRegistry, path + "." + declaredField.getName(), injectGenerators);
            }
            catch (DependencyInjectionException die) {
                throw new RuntimeException(die);
            }
        }
    }
}

