/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.dependency;

import io.probedock.junitee.dependency.DependencyInjectionException;
import io.probedock.junitee.utils.InflectorHelper;
import io.probedock.junitee.utils.NoValidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.ejb.Local;
import javax.ejb.Remote;

public class DependencyInjectorHelper {
    private DependencyInjectorHelper() {
    }

    static void injectField(Field field, Object holder, Object value) throws DependencyInjectionException {
        boolean fieldMustBeChanged = field.isAccessible();
        if (!fieldMustBeChanged) {
            field.setAccessible(true);
        }
        try {
            field.set(holder, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException ex) {
            throw new DependencyInjectionException("Unable to set the value [" + value + "] on field [" + field.getName() + "] of the object [" + holder.getClass().getSimpleName() + "].", ex);
        }
        finally {
            if (!fieldMustBeChanged) {
                field.setAccessible(false);
            }
        }
    }

    static Class findImplementationClass(Class cl) throws DependencyInjectionException {
        try {
            return InflectorHelper.retrieveInstantiableClassName(cl);
        }
        catch (NoValidClassException ex) {
            throw new DependencyInjectionException("Unable to instantiate a new object from type [" + cl.getCanonicalName() + "]. Maybe there is no empty constructor.", ex);
        }
    }

    static Class getMockInterface(Class mockClass) {
        Class current = mockClass;
        do {
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (interfaceClass.getAnnotation(Local.class) == null && interfaceClass.getAnnotation(Remote.class) == null) continue;
                return interfaceClass;
            }
        } while ((current = current.getSuperclass()) != Object.class);
        return null;
    }

    static Object instantiateMock(Class mockClass, Map<String, Object> mockRegistry) throws DependencyInjectionException {
        Class mockInterfaceClass = DependencyInjectorHelper.getMockInterface(mockClass);
        if (mockInterfaceClass == null) {
            throw new DependencyInjectionException("There is no suitable interfaces for class: " + mockClass.getCanonicalName());
        }
        if (mockRegistry.containsKey(mockInterfaceClass.getCanonicalName())) {
            return mockRegistry.get(mockInterfaceClass.getCanonicalName());
        }
        try {
            Object instanceOfImplementationClass = mockClass.newInstance();
            mockRegistry.put(mockInterfaceClass.getCanonicalName(), instanceOfImplementationClass);
            return instanceOfImplementationClass;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DependencyInjectionException("Unable to instantiate the Mock class: " + mockClass.getCanonicalName(), e);
        }
    }

    static Object instantiateEjb(Field ejbField, Map<String, Object> mockRegistry, Map<String, Object> ejbRegistry) throws DependencyInjectionException {
        Class implementationClass = DependencyInjectorHelper.findImplementationClass(ejbField.getType());
        if (ejbRegistry.containsKey(implementationClass.getCanonicalName())) {
            return ejbRegistry.get(implementationClass.getCanonicalName());
        }
        try {
            Class mockInterfaceClass = DependencyInjectorHelper.getMockInterface(implementationClass);
            Object instanceOfImplementationClass = mockInterfaceClass != null && mockRegistry.containsKey(mockInterfaceClass.getCanonicalName()) ? mockRegistry.get(mockInterfaceClass.getCanonicalName()) : implementationClass.newInstance();
            DependencyInjectorHelper.invokePostConstruct(instanceOfImplementationClass);
            ejbRegistry.put(implementationClass.getCanonicalName(), instanceOfImplementationClass);
            return instanceOfImplementationClass;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DependencyInjectionException("Unable to instantiate the EJB.", e);
        }
    }

    static void invokePostConstruct(Object obj) throws DependencyInjectionException {
        Class<?> cl = obj.getClass();
        do {
            for (Method m : cl.getDeclaredMethods()) {
                if (m.getAnnotation(PostConstruct.class) == null) continue;
                try {
                    boolean isAccessible = m.isAccessible();
                    if (!isAccessible) {
                        m.setAccessible(true);
                    }
                    m.invoke(obj, new Object[0]);
                    if (isAccessible) continue;
                    m.setAccessible(false);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new DependencyInjectionException("Unable to call the method " + m.getName() + " on object of class " + cl.getCanonicalName() + ". @PostConstruct methods must be empty args methods.");
                }
            }
        } while ((cl = cl.getSuperclass()) != Object.class);
    }

    static Object instantiateDataGenerator(Field generatorField, String path, Set<String> generatorRegistry) throws DependencyInjectionException {
        String currentPath = path + "." + generatorField.getName();
        Class implementationClass = DependencyInjectorHelper.findImplementationClass(generatorField.getType());
        if (generatorRegistry.contains(currentPath)) {
            throw new DependencyInjectionException("The data generator " + implementationClass.getSimpleName() + " already exists for the path: " + currentPath + ". It seems that you have a loop in your data generator configuration that is not allowed.");
        }
        try {
            Object instanceOfImplementationClass = implementationClass.newInstance();
            generatorRegistry.add(currentPath);
            return instanceOfImplementationClass;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new DependencyInjectionException("Unable to instantiate the data generator.", e);
        }
    }

    static Object getObject(Field field, Object holder) throws DependencyInjectionException {
        boolean fieldMustBeChanged = field.isAccessible();
        if (!fieldMustBeChanged) {
            field.setAccessible(true);
        }
        try {
            Object object = field.get(holder);
            return object;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new DependencyInjectionException("Unable to get the value on field [" + field.getName() + "] of the object [" + holder.getClass().getSimpleName() + "].", e);
        }
        finally {
            if (!fieldMustBeChanged) {
                field.setAccessible(false);
            }
        }
    }

    static boolean isNull(Field field, Object holder) throws DependencyInjectionException {
        return DependencyInjectorHelper.getObject(field, holder) == null;
    }
}

