/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.finder;

import io.probedock.junitee.dependency.DependencyInjector;
import io.probedock.junitee.finder.Finder;
import io.probedock.junitee.finder.FinderException;
import io.probedock.junitee.finder.IFinder;
import io.probedock.junitee.generator.DataGeneratorManager;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinderManager
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(DataGeneratorManager.class);
    private EntityManagerFactory entityManagerFactory;
    private Map<Class, IFinder> finders = new HashMap<Class, IFinder>();

    public FinderManager(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Statement apply(Statement base, Description description) {
        return this.internalApply(base, description);
    }

    public Statement internalApply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                FinderManager.this.manageFinders(description);
                base.evaluate();
            }
        };
    }

    public <T extends IFinder> T getFinder(Class<T> finderClass) {
        return (T)this.finders.get(finderClass);
    }

    private void manageFinders(Description description) throws FinderException {
        this.finders.clear();
        Finder finderAnnotation = (Finder)description.getAnnotation(Finder.class);
        if (finderAnnotation == null) {
            return;
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        for (Class<? extends IFinder> finderClass : finderAnnotation.value()) {
            if (this.finders.containsKey(finderClass)) {
                LOG.error("The finder [" + finderClass.getCanonicalName() + "] is already instantiated. One instance of each finder is allowed.");
                throw new FinderException("The finder " + finderClass.getCanonicalName() + " is already registered. " + "Only one instance of each finder can be specified in the annotation.");
            }
            this.finders.put(finderClass, (IFinder)Enhancer.create(finderClass, (Class[])new Class[]{IFinder.class}, (Callback)new FinderCallback(entityManager)));
        }
    }

    private static class FinderCallback
    implements MethodInterceptor {
        private boolean injected = false;
        private EntityManager em;

        public FinderCallback(EntityManager em) {
            this.em = em;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (!this.injected) {
                DependencyInjector.inject(obj, this.em, false);
            }
            if (method.getName().startsWith("find")) {
                this.em.clear();
            }
            return proxy.invokeSuper(obj, args);
        }
    }
}

