/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.generator;

import io.probedock.junitee.generator.DataGeneratorRunner;
import io.probedock.junitee.generator.IDataGenerator;
import java.util.HashMap;
import java.util.Map;

public abstract class CompositeDataGenerator
implements IDataGenerator {
    private DataGeneratorRunner first;
    private DataGeneratorRunner last;
    private Map<String, IDataGenerator> dataGenerators = new HashMap<String, IDataGenerator>();
    private int numberToGenerate = 0;
    private String prefix = null;

    public CompositeDataGenerator dependsOn(IDataGenerator dataGenerator) {
        return this.dependsOn(dataGenerator.getClass().getCanonicalName(), dataGenerator);
    }

    public CompositeDataGenerator dependsOn(String dataGeneratorName, IDataGenerator dataGenerator) {
        if (dataGenerator == this) {
            throw new IllegalArgumentException("The data generator cannot depends on itself.");
        }
        if (dataGeneratorName == null) {
            throw new IllegalArgumentException("The data generator name should be provided.");
        }
        if (this.dataGenerators.containsKey(dataGeneratorName)) {
            throw new IllegalArgumentException("Data generator " + dataGeneratorName + " already registered.");
        }
        this.dataGenerators.put(dataGeneratorName, dataGenerator);
        return this;
    }

    public CompositeDataGenerator numberToGenerate(int number) {
        this.numberToGenerate = number;
        return this;
    }

    public CompositeDataGenerator usePrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    protected int getNumberToGenerate() {
        return this.numberToGenerate;
    }

    protected String getPrefix() {
        return this.prefix;
    }

    protected <T> T getDataGenerator(Class<? extends T> dataGeneratorClass) {
        return this.getDataGenerator(dataGeneratorClass.getCanonicalName(), dataGeneratorClass);
    }

    protected <T> T getDataGenerator(String dataDataGeneratorName, Class<? extends T> dataGeneratorClass) {
        if (!this.dataGenerators.containsKey(dataDataGeneratorName)) {
            throw new IllegalStateException("There is no " + dataDataGeneratorName + " data generator.");
        }
        return (T)this.dataGenerators.get(dataDataGeneratorName);
    }

    protected final void register(IDataGenerator dataGenerator) {
        if (this.first == null) {
            this.first = this.last = new DataGeneratorRunner(dataGenerator);
        } else {
            this.last = this.last.setNext(dataGenerator);
        }
    }

    protected void setup() {
    }

    protected abstract void generateData();

    @Override
    public final void generate() {
        this.setup();
        if (this.first != null) {
            this.first.generate();
        }
        this.generateData();
    }

    protected abstract void cleanData();

    @Override
    public final void cleanup() {
        this.cleanData();
        if (this.last != null) {
            this.last.cleanup();
        }
    }
}

