/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.generator;

import io.probedock.junitee.dependency.DependencyInjector;
import io.probedock.junitee.generator.DataGenerator;
import io.probedock.junitee.generator.DataGeneratorException;
import io.probedock.junitee.generator.IDataGenerator;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataGeneratorManager
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(DataGeneratorManager.class);
    private EntityManagerFactory entityManagerFactory;
    private Map<Class, IDataGenerator> dataGenerators = new HashMap<Class, IDataGenerator>();
    private static Boolean testRunning = false;

    public DataGeneratorManager(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                EntityManager entityManager = DataGeneratorManager.this.entityManagerFactory.createEntityManager();
                try {
                    DataGeneratorManager.this.generate(description, entityManager);
                    testRunning = true;
                    base.evaluate();
                }
                finally {
                    testRunning = false;
                    DataGeneratorManager.this.cleanup(description, entityManager);
                }
            }
        };
    }

    public <T extends IDataGenerator> T getDataGenerator(Class<T> dataGeneratorClass) {
        if (this.dataGenerators.containsKey(dataGeneratorClass)) {
            return (T)this.dataGenerators.get(dataGeneratorClass);
        }
        throw new RuntimeException(new DataGeneratorException("The data generator " + dataGeneratorClass.getCanonicalName() + " is not present in the annotation."));
    }

    private void generate(Description description, EntityManager entityManager) throws DataGeneratorException {
        this.dataGenerators.clear();
        DataGenerator dgAnnotation = (DataGenerator)description.getAnnotation(DataGenerator.class);
        if (dgAnnotation == null) {
            return;
        }
        for (Class<? extends IDataGenerator> dataGeneratorClass : dgAnnotation.value()) {
            if (!this.dataGenerators.containsKey(dataGeneratorClass)) {
                try {
                    IDataGenerator dataGenerator = (IDataGenerator)Enhancer.create(dataGeneratorClass, (Class[])new Class[]{IDataGenerator.class}, (Callback)new GeneratorCallback(entityManager));
                    DependencyInjector.inject(dataGenerator, entityManager, true);
                    this.dataGenerators.put(dataGeneratorClass, dataGenerator);
                    continue;
                }
                catch (Exception ex) {
                    LOG.error("Injection failed during the creation of the data generator: " + dataGeneratorClass.getCanonicalName(), (Throwable)ex);
                    throw new DataGeneratorException("Unable to instantiate the data generator " + dataGeneratorClass.getCanonicalName(), ex);
                }
            }
            LOG.error("The data generator [" + dataGeneratorClass.getCanonicalName() + "] is already instantiated. One instance of each data generator is allowed.");
            throw new DataGeneratorException("The data generator " + dataGeneratorClass.getCanonicalName() + " is already registered. " + "Only one instance of each generator can be specified in the annotation.");
        }
        try {
            entityManager.getTransaction().begin();
            Class<? extends IDataGenerator>[] dataGeneratorClass = dgAnnotation.value();
            for (int i = 0; i < dataGeneratorClass.length; ++i) {
                this.getDataGenerator(dataGeneratorClass[i]).generate();
            }
            entityManager.getTransaction().commit();
        }
        catch (Exception e) {
            LOG.error("Unkown error", (Throwable)e);
            entityManager.getTransaction().rollback();
            throw new DataGeneratorException("An unexpected error occured during the data generation.", e);
        }
        finally {
            entityManager.clear();
        }
    }

    private void cleanup(Description description, EntityManager entityManager) throws DataGeneratorException {
        DataGenerator dgAnnotation = (DataGenerator)description.getAnnotation(DataGenerator.class);
        if (dgAnnotation != null && dgAnnotation.executeCleanup()) {
            try {
                entityManager.getTransaction().begin();
                Class<? extends IDataGenerator>[] dataGeneratorClass = dgAnnotation.value();
                for (int i = dataGeneratorClass.length - 1; i >= 0; --i) {
                    this.getDataGenerator(dataGeneratorClass[i]).cleanup();
                }
                entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                LOG.error("Unknow error", (Throwable)e);
                entityManager.getTransaction().rollback();
                throw new DataGeneratorException("An unexpected error occured during cleanup phase.", e);
            }
            finally {
                entityManager.clear();
            }
        }
    }

    private static class GeneratorCallback
    implements MethodInterceptor {
        private EntityManager entityManager;

        public GeneratorCallback(EntityManager entityManager) {
            this.entityManager = entityManager;
        }

        public Object intercept(Object obj, Method method, Object[] args, MethodProxy proxy) throws Throwable {
            if (testRunning.booleanValue() && method.getName().startsWith("create") || method.getName().startsWith("update") || method.getName().startsWith("delete")) {
                try {
                    this.entityManager.getTransaction().begin();
                    Object result = proxy.invokeSuper(obj, args);
                    this.entityManager.getTransaction().commit();
                    return result;
                }
                catch (Throwable t) {
                    if (this.entityManager.getTransaction().isActive()) {
                        this.entityManager.getTransaction().rollback();
                    }
                    throw t;
                }
            }
            return proxy.invokeSuper(obj, args);
        }
    }
}

