/*
 * Decompiled with CFR 0.152.
 */
package io.probedock.junitee.utils;

import io.probedock.junitee.utils.NoValidClassException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public final class InflectorHelper {
    private InflectorHelper() {
    }

    public static Class retrieveInstantiableClassName(Class cl) throws NoValidClassException {
        Class<?> implementationClass = cl;
        String packageName = cl.getPackage().getName();
        if (cl.isInterface()) {
            String simpleName = cl.getSimpleName().charAt(0) == 'I' && Character.isUpperCase(cl.getSimpleName().charAt(1)) ? cl.getSimpleName().substring(1) : cl.getSimpleName() + "Impl";
            try {
                implementationClass = cl.isMemberClass() ? InflectorHelper.class.getClassLoader().loadClass(packageName + "." + cl.getDeclaringClass().getSimpleName() + "$" + simpleName) : InflectorHelper.class.getClassLoader().loadClass(packageName + "." + simpleName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new NoValidClassException("Unable to find a concrete class for interface " + cl.getCanonicalName());
            }
        }
        if (!Modifier.isPublic(implementationClass.getModifiers())) {
            throw new NoValidClassException("The class " + implementationClass.getCanonicalName() + " is not public.");
        }
        if (implementationClass.isMemberClass() && !Modifier.isStatic(implementationClass.getModifiers())) {
            throw new NoValidClassException("The inner class should be static to be instantiated through junitee.");
        }
        try {
            Constructor constructor = implementationClass.getConstructor(new Class[0]);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new NoValidClassException("The empty constructor of class " + implementationClass.getSimpleName() + " must be public.");
            }
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new NoValidClassException("It seems that " + implementationClass.getSimpleName() + " has no empty constructor.");
        }
        return implementationClass;
    }
}

