/*
 * Decompiled with CFR 0.152.
 */
package io.progix.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.JsonPatchOperationType;
import io.progix.jackson.exceptions.JsonPatchFormatException;
import java.io.IOException;

public class JsonPatchOperationDeserializer
extends JsonDeserializer<JsonPatchOperation> {
    private UntypedObjectDeserializer untypedObjectDeserializer = new UntypedObjectDeserializer();

    public JsonPatchOperation deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        this.untypedObjectDeserializer.resolve(ctxt);
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode operationNode = node.get("op");
        if (operationNode == null || !operationNode.isTextual()) {
            throw new JsonPatchFormatException("'op' is missing or not a string: " + operationNode);
        }
        JsonPatchOperationType operation = JsonPatchOperationType.valueOf(operationNode.asText().toUpperCase());
        JsonNode pathNode = node.get("path");
        if (pathNode == null || !pathNode.isTextual()) {
            throw new JsonPatchFormatException("'path' is missing or not a string: " + pathNode);
        }
        if (operation == JsonPatchOperationType.REMOVE) {
            return new JsonPatchOperation(operation, JsonPointer.compile((String)pathNode.asText()));
        }
        if (operation == JsonPatchOperationType.COPY || operation == JsonPatchOperationType.MOVE) {
            JsonNode fromNode = node.get("from");
            if (fromNode == null || !fromNode.isTextual()) {
                throw new JsonPatchFormatException("'from' is missing or not a string (" + fromNode + ") and is required " + "for operation '" + (Object)((Object)operation) + "'");
            }
            return new JsonPatchOperation(operation, JsonPointer.compile((String)pathNode.asText()), JsonPointer.compile((String)fromNode.asText()));
        }
        if (operation == JsonPatchOperationType.ADD || operation == JsonPatchOperationType.REPLACE || operation == JsonPatchOperationType.TEST) {
            JsonNode valueNode = node.get("value");
            if (valueNode == null || valueNode.isMissingNode()) {
                throw new JsonPatchFormatException("'value' is missing and is required for operation '" + (Object)((Object)operation) + "'");
            }
            return new JsonPatchOperation(operation, JsonPointer.compile((String)pathNode.asText()), valueNode);
        }
        throw new RuntimeException("Unknown operation.");
    }
}

