/*
 * Decompiled with CFR 0.152.
 */
package io.progix.jackson.exceptions;

import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.databind.JsonNode;
import io.progix.jackson.JsonPatchOperation;
import io.progix.jackson.JsonPatchOperationType;

public class JsonPatchFailedException
extends RuntimeException {
    public JsonPatchFailedException(String message, Throwable cause) {
        super(message, cause);
    }

    public JsonPatchFailedException(String message) {
        super(message);
    }

    public JsonPatchFailedException(JsonPatchOperation instruction, String message) {
        super(JsonPatchFailedException.formatInstruction(instruction.getOperation(), instruction.getPath(), instruction.getValue(), instruction.getFrom()) + " failed: " + message);
    }

    public JsonPatchFailedException(JsonPatchOperation instruction, String message, Throwable cause) {
        super(JsonPatchFailedException.formatInstruction(instruction.getOperation(), instruction.getPath(), instruction.getValue(), instruction.getFrom()) + " failed: " + message, cause);
    }

    public JsonPatchFailedException(JsonPatchOperation instruction, Throwable cause) {
        super(JsonPatchFailedException.formatInstruction(instruction.getOperation(), instruction.getPath(), instruction.getValue(), instruction.getFrom()) + " failed: ", cause);
    }

    public JsonPatchFailedException(JsonPatchOperationType type, JsonPointer path, JsonNode value, JsonPointer from, String message) {
        super(JsonPatchFailedException.formatInstruction(type, path, value, from) + " failed: " + message);
    }

    public JsonPatchFailedException(JsonPatchOperationType type, JsonPointer path, JsonNode value, JsonPointer from, String message, Throwable cause) {
        super(JsonPatchFailedException.formatInstruction(type, path, value, from) + " failed: " + message, cause);
    }

    public JsonPatchFailedException(JsonPatchOperationType type, JsonPointer path, JsonNode value, JsonPointer from, Throwable cause) {
        super(JsonPatchFailedException.formatInstruction(type, path, value, from) + " failed: ", cause);
    }

    private static String formatInstruction(JsonPatchOperationType type, JsonPointer path, JsonNode value, JsonPointer from) {
        String formatted = (Object)((Object)type) + " ";
        switch (type) {
            case ADD: {
                formatted = formatted + value + " to " + path;
                break;
            }
            case REMOVE: {
                formatted = formatted + path;
                break;
            }
            case REPLACE: {
                formatted = formatted + path + " with " + value;
                break;
            }
            case COPY: {
                formatted = formatted + path + " to " + from;
                break;
            }
            case TEST: {
                formatted = formatted + path + " is " + value;
                break;
            }
            case MOVE: {
                formatted = formatted + path + " to " + from;
            }
        }
        return formatted;
    }
}

