/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoSumDouble<T>
extends MonoSource<T, Double>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumDouble(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(source);
        this.mapping = mapping;
    }

    public void subscribe(Subscriber<? super Double> s) {
        this.source.subscribe(new SumLongSubscriber<T>(s, this.mapping));
    }

    static final class SumLongSubscriber<T>
    extends MathSubscriber<T, Double> {
        final Function<? super T, ? extends Number> mapping;
        double sum;
        boolean hasValue;

        SumLongSubscriber(Subscriber<? super Double> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            double doubleValue = this.mapping.apply(newValue).doubleValue();
            this.sum = this.hasValue ? this.sum + doubleValue : doubleValue;
            this.hasValue = true;
        }

        @Override
        protected Double result() {
            return this.hasValue ? Double.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0.0;
            this.hasValue = false;
        }
    }
}

