/*
 * Decompiled with CFR 0.152.
 */
package reactor.math;

import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.Fuseable;
import reactor.core.publisher.MonoSource;
import reactor.math.MathSubscriber;

final class MonoSumLong<T>
extends MonoSource<T, Long>
implements Fuseable {
    final Function<? super T, ? extends Number> mapping;

    MonoSumLong(Publisher<? extends T> source, Function<? super T, ? extends Number> mapping) {
        super(source);
        this.mapping = mapping;
    }

    public void subscribe(Subscriber<? super Long> s) {
        this.source.subscribe(new SumLongSubscriber<T>(s, this.mapping));
    }

    static final class SumLongSubscriber<T>
    extends MathSubscriber<T, Long> {
        final Function<? super T, ? extends Number> mapping;
        long sum;
        boolean hasValue;

        SumLongSubscriber(Subscriber<? super Long> actual, Function<? super T, ? extends Number> mapping) {
            super(actual);
            this.mapping = mapping;
        }

        @Override
        protected void updateResult(T newValue) {
            long longValue = this.mapping.apply(newValue).longValue();
            this.sum = this.hasValue ? this.sum + longValue : longValue;
            this.hasValue = true;
        }

        @Override
        protected Long result() {
            return this.hasValue ? Long.valueOf(this.sum) : null;
        }

        @Override
        protected void reset() {
            this.sum = 0L;
            this.hasValue = false;
        }
    }
}

