/*
 * Decompiled with CFR 0.152.
 */
package reactor.extra.processor;

import java.util.function.LongSupplier;
import reactor.extra.processor.RhsPadding;
import reactor.extra.processor.RingBuffer;
import reactor.extra.processor.Value;
import sun.misc.Unsafe;

final class UnsafeSequence
extends RhsPadding
implements RingBuffer.Sequence,
LongSupplier {
    private static final Unsafe UNSAFE = (Unsafe)RingBuffer.getUnsafe();
    private static final long VALUE_OFFSET;

    UnsafeSequence(long initialValue) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, initialValue);
    }

    @Override
    public long getAsLong() {
        return this.value;
    }

    @Override
    public void set(long value) {
        UNSAFE.putOrderedLong(this, VALUE_OFFSET, value);
    }

    @Override
    public boolean compareAndSet(long expectedValue, long newValue) {
        return UNSAFE.compareAndSwapLong(this, VALUE_OFFSET, expectedValue, newValue);
    }

    static {
        try {
            VALUE_OFFSET = UNSAFE.objectFieldOffset(Value.class.getDeclaredField("value"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

