/*
 * Decompiled with CFR 0.152.
 */
package reactor.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.LoggingEvent;
import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleQueueBuilder;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.tools.ChronicleTools;
import reactor.logback.AsyncAppender;
import reactor.logback.LoggingEventRecord;

public class DurableAsyncAppender
extends AsyncAppender {
    private final Object writeMonitor = new Object();
    private String basePath = "log";
    private Chronicle chronicle;
    private ExcerptAppender appender;

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String chronicle) {
        this.basePath = chronicle;
    }

    @Override
    protected void doStart() {
        ChronicleTools.warmup();
        this.basePath = this.basePath.endsWith("/") ? this.basePath + this.getName() : this.basePath + "/" + this.getName();
        try {
            this.chronicle = ChronicleQueueBuilder.indexed((String)this.basePath).synchronous(true).build();
            this.appender = this.chronicle.createAppender();
        }
        catch (Throwable t) {
            this.addError(t.getMessage(), t);
        }
    }

    @Override
    protected void doStop() {
        try {
            this.appender.flush();
            this.chronicle.close();
        }
        catch (IOException e) {
            this.addError(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void queueLoggingEvent(ILoggingEvent evt) {
        Object object = this.writeMonitor;
        synchronized (object) {
            LoggingEventRecord.write(this.appender, (LoggingEvent)evt, this.isIncludeCallerData(), 1);
        }
        super.queueLoggingEvent(evt);
    }
}

