/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool.introspection.micrometer;

import io.micrometer.core.instrument.MeterRegistry;
import reactor.pool.InstrumentedPool;
import reactor.pool.PoolBuilder;
import reactor.pool.PoolMetricsRecorder;
import reactor.pool.introspection.micrometer.MicrometerMetricsRecorder;
import reactor.pool.introspection.micrometer.PoolGaugesBinder;

public final class Micrometer {
    public static <POOLABLE> InstrumentedPool<POOLABLE> instrumentedPool(PoolBuilder<POOLABLE, ?> poolBuilder, String poolName, MeterRegistry meterRegistry) {
        PoolMetricsRecorder recorder = Micrometer.recorder(poolName, meterRegistry);
        InstrumentedPool pool = poolBuilder.metricsRecorder(recorder).buildPool();
        Micrometer.gaugesOf(pool.metrics(), poolName, meterRegistry);
        return pool;
    }

    public static void gaugesOf(InstrumentedPool.PoolMetrics poolMetrics, String poolName, MeterRegistry meterRegistry) {
        new PoolGaugesBinder(poolMetrics, poolName).bindTo(meterRegistry);
    }

    public static PoolMetricsRecorder recorder(String poolName, MeterRegistry meterRegistry) {
        return new MicrometerMetricsRecorder(poolName, meterRegistry);
    }
}

