/*
 * Decompiled with CFR 0.152.
 */
package reactor.pool.introspection.micrometer;

import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.binder.MeterBinder;
import reactor.pool.InstrumentedPool;
import reactor.pool.introspection.micrometer.PoolMetersDocumentation;

public final class PoolGaugesBinder
implements MeterBinder {
    private final InstrumentedPool.PoolMetrics poolMetrics;
    private final String poolName;

    public PoolGaugesBinder(InstrumentedPool.PoolMetrics poolMetrics, String poolName) {
        this.poolMetrics = poolMetrics;
        this.poolName = poolName;
    }

    public void bindTo(MeterRegistry meterRegistry) {
        Tags nameTag = Tags.of((String)PoolMetersDocumentation.CommonTags.POOL_NAME.asString(), (String)this.poolName);
        Gauge.builder((String)PoolMetersDocumentation.ACQUIRED.getName(), (Object)this.poolMetrics, InstrumentedPool.PoolMetrics::acquiredSize).tags((Iterable)nameTag).register(meterRegistry);
        Gauge.builder((String)PoolMetersDocumentation.ALLOCATED.getName(), (Object)this.poolMetrics, InstrumentedPool.PoolMetrics::allocatedSize).tags((Iterable)nameTag).register(meterRegistry);
        Gauge.builder((String)PoolMetersDocumentation.IDLE.getName(), (Object)this.poolMetrics, InstrumentedPool.PoolMetrics::idleSize).tags((Iterable)nameTag).register(meterRegistry);
        Gauge.builder((String)PoolMetersDocumentation.PENDING_ACQUIRE.getName(), (Object)this.poolMetrics, InstrumentedPool.PoolMetrics::pendingAcquireSize).tags((Iterable)nameTag).register(meterRegistry);
    }
}

