/*
 * Decompiled with CFR 0.152.
 */
package reactor.test.publisher;

import java.util.EnumSet;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.Fuseable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Operators;
import reactor.test.publisher.TestPublisher;

class DefaultTestPublisher<T>
extends TestPublisher<T> {
    private static final TestPublisherSubscription[] EMPTY = new TestPublisherSubscription[0];
    private static final TestPublisherSubscription[] TERMINATED = new TestPublisherSubscription[0];
    volatile int cancelCount;
    static final AtomicIntegerFieldUpdater<DefaultTestPublisher> CANCEL_COUNT = AtomicIntegerFieldUpdater.newUpdater(DefaultTestPublisher.class, "cancelCount");
    Throwable error;
    volatile boolean hasOverflown;
    final EnumSet<TestPublisher.Violation> violations;
    volatile TestPublisherSubscription<T>[] subscribers = EMPTY;
    static final AtomicReferenceFieldUpdater<DefaultTestPublisher, TestPublisherSubscription[]> SUBSCRIBERS = AtomicReferenceFieldUpdater.newUpdater(DefaultTestPublisher.class, TestPublisherSubscription[].class, "subscribers");

    DefaultTestPublisher(TestPublisher.Violation first, TestPublisher.Violation ... rest) {
        this.violations = EnumSet.of(first, rest);
    }

    DefaultTestPublisher() {
        this.violations = EnumSet.noneOf(TestPublisher.Violation.class);
    }

    public void subscribe(Subscriber<? super T> s) {
        Objects.requireNonNull(s, "s");
        TestPublisherSubscription<? super T> p = new TestPublisherSubscription<T>(s, this);
        s.onSubscribe(p);
        if (this.add(p)) {
            if (p.cancelled) {
                this.remove(p);
            }
        } else {
            Throwable e = this.error;
            if (e != null) {
                s.onError(e);
            } else {
                s.onComplete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean add(TestPublisherSubscription<T> s) {
        TestPublisherSubscription<T>[] a = this.subscribers;
        if (a == TERMINATED) {
            return false;
        }
        DefaultTestPublisher defaultTestPublisher = this;
        synchronized (defaultTestPublisher) {
            a = this.subscribers;
            if (a == TERMINATED) {
                return false;
            }
            int len = a.length;
            TestPublisherSubscription[] b = new TestPublisherSubscription[len + 1];
            System.arraycopy(a, 0, b, 0, len);
            b[len] = s;
            this.subscribers = b;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(TestPublisherSubscription<T> s) {
        TestPublisherSubscription<T>[] a = this.subscribers;
        if (this.violations.contains((Object)TestPublisher.Violation.CLEANUP_ON_TERMINATE)) {
            return;
        }
        if (a == TERMINATED || a == EMPTY) {
            return;
        }
        DefaultTestPublisher defaultTestPublisher = this;
        synchronized (defaultTestPublisher) {
            a = this.subscribers;
            if (a == TERMINATED || a == EMPTY) {
                return;
            }
            int len = a.length;
            int j = -1;
            for (int i = 0; i < len; ++i) {
                if (a[i] != s) continue;
                j = i;
                break;
            }
            if (j < 0) {
                return;
            }
            if (len == 1) {
                this.subscribers = EMPTY;
                return;
            }
            TestPublisherSubscription[] b = new TestPublisherSubscription[len - 1];
            System.arraycopy(a, 0, b, 0, j);
            System.arraycopy(a, j + 1, b, j, len - j - 1);
            this.subscribers = b;
        }
    }

    @Override
    public Flux<T> flux() {
        return Flux.from((Publisher)this);
    }

    @Override
    public Mono<T> mono() {
        return Mono.from((Publisher)this);
    }

    @Override
    public DefaultTestPublisher<T> assertMinRequested(long n) {
        TestPublisherSubscription<T>[] subs = this.subscribers;
        long minRequest = Stream.of(subs).mapToLong(s -> s.requested).min().orElse(0L);
        if (minRequest < n) {
            throw new AssertionError((Object)("Expected minimum request of " + n + "; got " + minRequest));
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertSubscribers() {
        TestPublisherSubscription<T>[] s = this.subscribers;
        if (s == EMPTY || s == TERMINATED) {
            throw new AssertionError((Object)"Expected subscribers");
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertSubscribers(int n) {
        int sl = this.subscribers.length;
        if (sl != n) {
            throw new AssertionError((Object)("Expected " + n + " subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertNoSubscribers() {
        int sl = this.subscribers.length;
        if (sl != 0) {
            throw new AssertionError((Object)("Expected no subscribers, got " + sl));
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertCancelled() {
        if (this.cancelCount == 0) {
            throw new AssertionError((Object)"Expected at least 1 cancellation");
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertCancelled(int n) {
        int cc = this.cancelCount;
        if (cc != n) {
            throw new AssertionError((Object)("Expected " + n + " cancellations, got " + cc));
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertNotCancelled() {
        if (this.cancelCount != 0) {
            throw new AssertionError((Object)"Expected no cancellation");
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertRequestOverflow() {
        if (!this.hasOverflown) {
            throw new AssertionError((Object)"Expected some request overflow");
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> assertNoRequestOverflow() {
        if (this.hasOverflown) {
            throw new AssertionError((Object)"Unexpected request overflow");
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> next(T t) {
        if (!this.violations.contains((Object)TestPublisher.Violation.ALLOW_NULL)) {
            Objects.requireNonNull(t, "emitted values must be non-null");
        }
        for (TestPublisherSubscription<T> s : this.subscribers) {
            s.onNext(t);
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> error(Throwable t) {
        Objects.requireNonNull(t, "t");
        this.error = t;
        TestPublisherSubscription<T>[] subs = this.violations.contains((Object)TestPublisher.Violation.CLEANUP_ON_TERMINATE) ? this.subscribers : SUBSCRIBERS.getAndSet(this, TERMINATED);
        for (TestPublisherSubscription<T> s : subs) {
            s.onError(t);
        }
        return this;
    }

    @Override
    public DefaultTestPublisher<T> complete() {
        TestPublisherSubscription<T>[] subs = this.violations.contains((Object)TestPublisher.Violation.CLEANUP_ON_TERMINATE) ? this.subscribers : SUBSCRIBERS.getAndSet(this, TERMINATED);
        for (TestPublisherSubscription<T> s : subs) {
            s.onComplete();
        }
        return this;
    }

    static final class TestPublisherSubscription<T>
    implements Subscription {
        final Subscriber<? super T> actual;
        final Fuseable.ConditionalSubscriber<? super T> actualConditional;
        final DefaultTestPublisher<T> parent;
        volatile boolean cancelled;
        volatile long requested;
        static final AtomicLongFieldUpdater<TestPublisherSubscription> REQUESTED = AtomicLongFieldUpdater.newUpdater(TestPublisherSubscription.class, "requested");

        TestPublisherSubscription(Subscriber<? super T> actual, DefaultTestPublisher<T> parent) {
            this.actual = actual;
            this.actualConditional = actual instanceof Fuseable.ConditionalSubscriber ? (Fuseable.ConditionalSubscriber)actual : null;
            this.parent = parent;
        }

        public void request(long n) {
            if (Operators.validate((long)n)) {
                Operators.getAndAddCap(REQUESTED, (Object)this, (long)n);
            }
        }

        public void cancel() {
            if (!this.cancelled) {
                CANCEL_COUNT.incrementAndGet(this.parent);
                if (this.parent.violations.contains((Object)TestPublisher.Violation.CLEANUP_ON_TERMINATE)) {
                    return;
                }
                this.cancelled = true;
                this.parent.remove(this);
            }
        }

        void onNext(T value) {
            long r = this.requested;
            if (r != 0L || this.parent.violations.contains((Object)TestPublisher.Violation.REQUEST_OVERFLOW)) {
                boolean sent;
                if (r == 0L) {
                    this.parent.hasOverflown = true;
                }
                if (this.actualConditional != null) {
                    sent = this.actualConditional.tryOnNext(value);
                } else {
                    sent = true;
                    this.actual.onNext(value);
                }
                if (sent && r != Long.MAX_VALUE) {
                    REQUESTED.decrementAndGet(this);
                }
                return;
            }
            this.parent.remove(this);
            this.actual.onError((Throwable)new IllegalStateException("Can't deliver value due to lack of requests"));
        }

        void onError(Throwable e) {
            this.actual.onError(e);
        }

        void onComplete() {
            this.actual.onComplete();
        }
    }
}

