/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.stream;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.ipc.connector.Connector;
import reactor.ipc.connector.Inbound;
import reactor.ipc.connector.Outbound;
import reactor.ipc.stream.StreamConnector;
import reactor.ipc.stream.StreamOperations;
import reactor.ipc.stream.StreamOutbound;

final class SimpleStreamConnector<IN, OUT, INBOUND extends Inbound<IN>, OUTBOUND extends Outbound<OUT>>
implements StreamConnector<IN, OUT, INBOUND, OUTBOUND> {
    final Connector<IN, OUT, INBOUND, OUTBOUND> connector;
    final BiConsumer<? super INBOUND, StreamOperations> decoder;
    final Function<? super OUTBOUND, ? extends StreamOutbound> encoder;

    SimpleStreamConnector(Connector<IN, OUT, INBOUND, OUTBOUND> connector, BiConsumer<? super INBOUND, StreamOperations> decoder, Function<? super OUTBOUND, ? extends StreamOutbound> encoder) {
        this.connector = Objects.requireNonNull(connector, "connector");
        this.decoder = decoder;
        this.encoder = encoder;
    }

    @Override
    public <API> Mono<API> newBidirectional(Supplier<?> receiverSupplier, Class<? extends API> api) {
        return this.newStreamSupport(receiverSupplier, api, this.decoder, this.encoder);
    }

    @Override
    public Mono<? extends Disposable> newHandler(BiFunction<? super INBOUND, ? super OUTBOUND, ? extends Publisher<Void>> ioHandler) {
        return this.connector.newHandler(ioHandler);
    }
}

