/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.stream;

import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.ipc.connector.Connector;
import reactor.ipc.connector.Inbound;
import reactor.ipc.connector.Outbound;
import reactor.ipc.stream.SimpleStreamConnector;
import reactor.ipc.stream.StreamOperations;
import reactor.ipc.stream.StreamOutbound;
import reactor.ipc.stream.StreamSetup;

public interface StreamConnector<IN, OUT, INBOUND extends Inbound<IN>, OUTBOUND extends Outbound<OUT>>
extends Connector<IN, OUT, INBOUND, OUTBOUND> {
    public static <IN, OUT, INBOUND extends Inbound<IN>, OUTBOUND extends Outbound<OUT>> StreamConnector<IN, OUT, INBOUND, OUTBOUND> from(Connector<IN, OUT, INBOUND, OUTBOUND> connector, BiConsumer<? super INBOUND, StreamOperations> decoder, Function<? super OUTBOUND, ? extends StreamOutbound> encoder) {
        return new SimpleStreamConnector<IN, OUT, INBOUND, OUTBOUND>(connector, decoder, encoder);
    }

    default public Mono<? extends Disposable> newReceiver(Supplier<?> receiverSupplier) {
        Objects.requireNonNull(receiverSupplier, "receiver");
        return this.newBidirectional(receiverSupplier, null);
    }

    default public <API> Mono<API> newProducer(Class<? extends API> api) {
        Objects.requireNonNull(api, "api");
        return this.newBidirectional(null, api);
    }

    public <API> Mono<API> newBidirectional(Supplier<?> var1, Class<? extends API> var2);

    default public <API> Mono<API> newStreamSupport(Supplier<?> receiverSupplier, Class<? extends API> api, BiConsumer<? super INBOUND, StreamOperations> decoder, Function<? super OUTBOUND, ? extends StreamOutbound> encoder) {
        return StreamSetup.connect(this, receiverSupplier, api, decoder, encoder);
    }
}

