/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.stream;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.Disposable;
import reactor.core.publisher.DirectProcessor;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;
import reactor.ipc.connector.Connector;
import reactor.ipc.connector.Inbound;
import reactor.ipc.connector.Outbound;
import reactor.ipc.stream.Ipc;
import reactor.ipc.stream.IpcServiceMapper;
import reactor.ipc.stream.StreamContextImpl;
import reactor.ipc.stream.StreamOperations;
import reactor.ipc.stream.StreamOperationsImpl;
import reactor.ipc.stream.StreamOutbound;

abstract class StreamSetup {
    private StreamSetup() {
    }

    static <I, O, II extends Inbound<I>, OO extends Outbound<O>, API> Mono<API> connect(Connector<I, O, II, OO> connector, Supplier<?> receiverSupplier, Class<? extends API> api, BiConsumer<? super II, StreamOperations> decoder, Function<? super OO, ? extends StreamOutbound> encoder) {
        return Mono.create(new OnConnectorSubscribe<I, O, II, OO, API>(connector, receiverSupplier, api, decoder, encoder));
    }

    static final class OnConnectorSubscribe<I, O, II extends Inbound<I>, OO extends Outbound<O>, API>
    implements Consumer<MonoSink<API>> {
        final Connector<I, O, II, OO> connector;
        final Supplier<?> localSupplier;
        final Class<? extends API> remoteApi;
        final String endpointName;
        final BiConsumer<? super II, StreamOperations> ipcReader;
        final Function<? super OO, ? extends StreamOutbound> ipcWriter;

        OnConnectorSubscribe(Connector<I, O, II, OO> connector, Supplier<?> localSupplier, Class<? extends API> remoteApi, BiConsumer<? super II, StreamOperations> ipcReader, Function<? super OO, ? extends StreamOutbound> ipcWriter) {
            this.connector = Objects.requireNonNull(connector, "connector");
            this.endpointName = connector.getClass().getSimpleName().toLowerCase();
            this.ipcReader = ipcReader;
            this.ipcWriter = ipcWriter;
            this.localSupplier = localSupplier;
            this.remoteApi = remoteApi;
        }

        @Override
        public void accept(MonoSink<API> sink) {
            Object localAPI = this.localSupplier == null ? null : Objects.requireNonNull(this.localSupplier.get(), "localSupplier");
            Mono<Disposable> connect = this.connector.newHandler((in, out) -> {
                Object api;
                Object closing;
                StreamOperationsImpl[] am = new StreamOperationsImpl[]{null};
                if (this.remoteApi != null) {
                    Map<String, Object> clientMap = IpcServiceMapper.clientServiceMap(this.remoteApi);
                    closing = Disposable.class.isAssignableFrom(this.remoteApi) ? DirectProcessor.create() : null;
                    api = this.remoteApi.cast(Proxy.newProxyInstance(this.remoteApi.getClassLoader(), new Class[]{this.remoteApi}, (arg_0, arg_1, arg_2) -> OnConnectorSubscribe.lambda$null$0((DirectProcessor)closing, clientMap, am, arg_0, arg_1, arg_2)));
                } else {
                    api = null;
                    closing = null;
                }
                StreamContextImpl<Object> ctx = new StreamContextImpl<Object>(api);
                StreamOutbound streamOutbound = Objects.requireNonNull(this.ipcWriter.apply(out), "remote");
                if (localAPI != null) {
                    Map<String, Object> serverMap = IpcServiceMapper.serverServiceMap(localAPI);
                    am[0] = new StreamOperationsImpl(this.endpointName, (streamId, function, iom) -> {
                        Object action = serverMap.get(function);
                        if (action == null) {
                            throw new IllegalStateException("Function " + function + " not found");
                        }
                        return IpcServiceMapper.dispatchServer(streamId, action, iom, ctx);
                    }, streamOutbound, in, () -> IpcServiceMapper.invokeDone(localAPI, ctx));
                    IpcServiceMapper.invokeInit(localAPI, ctx);
                } else {
                    am[0] = new StreamOperationsImpl(this.endpointName, (streamId, function, iom) -> false, streamOutbound, in, () -> {});
                }
                if (this.ipcReader != null) {
                    this.ipcReader.accept(in, am[0]);
                }
                if (api != null) {
                    sink.success(api);
                }
                return closing != null ? closing : Mono.never();
            });
            Disposable c = this.remoteApi != null ? connect.subscribe(null, arg_0 -> sink.error(arg_0)) : connect.subscribe(connectedState -> sink.success(connectedState), arg_0 -> sink.error(arg_0));
            sink.onCancel(c);
        }

        private static /* synthetic */ Object lambda$null$0(DirectProcessor closing, Map clientMap, StreamOperationsImpl[] am, Object o, Method m, Object[] args) throws Throwable {
            Object action;
            String name = m.getName();
            Ipc a = m.getAnnotation(Ipc.class);
            if (a == null) {
                if (closing != null && m.getDeclaringClass().equals(Disposable.class)) {
                    closing.onComplete();
                    return null;
                }
                throw new IllegalArgumentException("The method '" + m.getName() + "' is not annotated with Ipc");
            }
            String aname = a.name();
            if (!aname.isEmpty()) {
                name = aname;
            }
            if ((action = clientMap.get(name)) == null) {
                throw new IllegalArgumentException("The method '" + m.getName() + "' is not a proper Ipc method");
            }
            return IpcServiceMapper.dispatchClient(name, action, args, am[0]);
        }
    }
}

