/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.ipc.Channel;

public abstract class DuplexSocket<IN, OUT, CONN extends Channel<IN, OUT>> {
    public static final int DEFAULT_PORT = System.getenv("PORT") != null ? Integer.parseInt(System.getenv("PORT")) : 12012;
    public static final String DEFAULT_BIND_ADDRESS = "127.0.0.1";
    protected final AtomicBoolean started = new AtomicBoolean();

    public boolean isShutdown() {
        return !this.started.get();
    }

    public final Mono<Void> shutdown() {
        if (this.started.compareAndSet(true, false)) {
            return this.doShutdown();
        }
        return Mono.empty();
    }

    public final void shutdownAndAwait() throws InterruptedException {
        this.shutdown().block();
    }

    public final Mono<Void> start(Function<? super CONN, ? extends Publisher<Void>> handler) {
        if (!this.started.compareAndSet(false, true) && this.shouldFailOnStarted()) {
            throw new IllegalStateException("DuplexSocket already started");
        }
        return this.doStart(handler);
    }

    public final void startAndAwait(Function<? super CONN, ? extends Publisher<Void>> handler) throws InterruptedException {
        this.start(handler).block();
    }

    protected abstract Mono<Void> doStart(Function<? super CONN, ? extends Publisher<Void>> var1);

    protected abstract Mono<Void> doShutdown();

    protected boolean shouldFailOnStarted() {
        return true;
    }
}

