/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Supplier;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Mono;

public class MonoChannelFuture<C extends Future>
extends Mono<Void> {
    final C future;

    public static Mono<Void> from(Future future) {
        return new MonoChannelFuture<Future>(future);
    }

    public static Mono<Void> from(Supplier<? extends Future> deferredFuture) {
        return Mono.defer(() -> new MonoChannelFuture<Future>((Future)deferredFuture.get()));
    }

    protected MonoChannelFuture(C future) {
        this.future = future;
    }

    public final void subscribe(Subscriber<? super Void> s) {
        this.future.addListener((GenericFutureListener)new SubscriberFutureBridge(s));
    }

    protected void doComplete(C future, Subscriber<? super Void> s) {
        s.onComplete();
    }

    protected void doError(Subscriber<? super Void> s, Throwable throwable) {
        s.onError(throwable);
    }

    final class SubscriberFutureBridge
    implements GenericFutureListener<Future<?>> {
        private final Subscriber<? super Void> s;

        public SubscriberFutureBridge(Subscriber<? super Void> s) {
            this.s = s;
            s.onSubscribe(new Subscription(){

                public void request(long n) {
                }

                public void cancel() {
                    MonoChannelFuture.this.future.removeListener((GenericFutureListener)SubscriberFutureBridge.this);
                }
            });
        }

        public void operationComplete(Future<?> future) throws Exception {
            if (!future.isSuccess()) {
                MonoChannelFuture.this.doError(this.s, future.cause());
            } else {
                MonoChannelFuture.this.doComplete(future, this.s);
            }
        }
    }
}

