/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.ipc.buffer.Buffer;
import reactor.ipc.codec.Codec;
import reactor.ipc.codec.DelimitedCodec;
import reactor.ipc.codec.StandardCodecs;
import reactor.ipc.codec.StringCodec;
import reactor.ipc.codec.compress.GzipCodec;
import reactor.ipc.codec.json.JsonCodec;

public final class NettyCodec<IN, OUT> {
    private final Codec<Buffer, IN, OUT> codec;

    public static NettyCodec<String, String> delimitedString() {
        return NettyCodec.from(StandardCodecs.DELIMITED_STRING_CODEC);
    }

    public static NettyCodec<String, String> delimitedString(Charset charset) {
        return NettyCodec.delimitedString(charset, (byte)0);
    }

    public static NettyCodec<String, String> delimitedString(Charset charset, byte delimiter) {
        return NettyCodec.from(new DelimitedCodec((Codec)new StringCodec(Byte.valueOf(delimiter), charset)));
    }

    public static <IN, OUT> NettyCodec<IN, OUT> from(Codec<Buffer, IN, OUT> codec) {
        return new NettyCodec<IN, OUT>(codec);
    }

    public static NettyCodec<Buffer, Buffer> gzip() {
        return NettyCodec.from(new GzipCodec(StandardCodecs.PASS_THROUGH_CODEC));
    }

    public static <T> NettyCodec<T, T> json(Class<T> tClass) {
        return NettyCodec.from(new JsonCodec(tClass));
    }

    public static NettyCodec<String, String> linefeed() {
        return NettyCodec.from(StandardCodecs.LINE_FEED_CODEC);
    }

    public static NettyCodec<String, String> linefeed(Charset charset) {
        return NettyCodec.from(new DelimitedCodec((Codec)new StringCodec(charset)));
    }

    public static NettyCodec<String, String> linefeed(Charset charset, byte delimiter) {
        return NettyCodec.linefeed(charset, delimiter, true);
    }

    public static NettyCodec<String, String> linefeed(Charset charset, byte delimiter, boolean stripDelimiter) {
        return NettyCodec.from(new DelimitedCodec(delimiter, stripDelimiter, (Codec)new StringCodec(charset)));
    }

    public static NettyCodec<String, String> string(Charset charset) {
        return NettyCodec.from(new StringCodec(charset));
    }

    private NettyCodec(Codec<Buffer, IN, OUT> codec) {
        this.codec = Objects.requireNonNull(codec, "Delegate codec cannot be null");
    }

    public Function<? super Publisher<ByteBuf>, ? extends Publisher<IN>> decoder() {
        return flux -> this.codec.decode((Publisher)Flux.from((Publisher)flux).map(bb -> new Buffer(bb.nioBuffer())));
    }

    public Function<? super Publisher<? extends OUT>, ? extends Publisher<ByteBuf>> encoder() {
        return flux -> this.codec.encode(flux).map(b -> Unpooled.wrappedBuffer((ByteBuffer)b.byteBuffer()));
    }

    static {
        try {
            NettyCodec.class.getClassLoader().loadClass("reactor.ipc.codec.Codec");
        }
        catch (ClassNotFoundException cfne) {
            throw new IllegalStateException("io.projectreactor.addons:reactor-codec dependency is missing from the classpath.");
        }
    }
}

