/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.Channel;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.ipc.Inbound;
import reactor.ipc.netty.common.ByteBufEncodedFlux;
import reactor.ipc.netty.common.NettyChannel;
import reactor.ipc.netty.common.NettyCodec;
import reactor.ipc.netty.common.ReleasingBufferInputStream;

public interface NettyInbound
extends Inbound<ByteBuf> {
    public static final Function<Object, ByteBuf> objectMapper = o -> {
        if (o instanceof ByteBuf) {
            return (ByteBuf)o;
        }
        if (o instanceof ByteBufHolder) {
            return ((ByteBufHolder)o).content();
        }
        throw new IllegalArgumentException("Object " + o + " of type " + o.getClass() + " cannot be converted to ByteBuf");
    };

    public Channel delegate();

    public NettyChannel.Lifecycle on();

    default public ByteBufEncodedFlux receive() {
        return new ByteBufEncodedFlux((Publisher<? extends ByteBuf>)this.receiveObject().map(objectMapper), this.delegate().alloc());
    }

    default public <NEW_IN> Flux<NEW_IN> receive(NettyCodec<NEW_IN, ?> codec) {
        return this.receive(codec.decoder());
    }

    default public Flux<ByteBuffer> receiveByteBuffer() {
        return this.receive().map(ByteBuf::nioBuffer);
    }

    default public Flux<byte[]> receiveByteArray() {
        return this.receive().map(bb -> {
            byte[] bytes = new byte[bb.readableBytes()];
            bb.readBytes(bytes);
            return bytes;
        });
    }

    default public Flux<InputStream> receiveInputStream() {
        return this.receive().map(ReleasingBufferInputStream::new);
    }

    public Flux<?> receiveObject();

    default public Flux<String> receiveString() {
        return this.receiveString(Charset.defaultCharset());
    }

    default public Flux<String> receiveString(Charset charset) {
        return this.receive().map(s -> s.toString(charset));
    }

    public InetSocketAddress remoteAddress();
}

