/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.DefaultFileRegion;
import io.netty.util.concurrent.Future;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.ipc.Outbound;
import reactor.ipc.netty.common.MonoChannelFuture;
import reactor.ipc.netty.common.NettyChannel;
import reactor.ipc.netty.common.NettyCodec;

public interface NettyOutbound
extends Outbound<ByteBuf> {
    public Channel delegate();

    public NettyOutbound flushEach();

    default public <OLD_OUT> Mono<Void> map(Publisher<? extends OLD_OUT> dataStream, NettyCodec<?, OLD_OUT> codec) {
        return this.map(dataStream, codec.encoder());
    }

    default public <OLD_OUT> Mono<Void> mapAndFlush(Publisher<? extends Publisher<? extends OLD_OUT>> dataStreams, NettyCodec<?, OLD_OUT> codec) {
        return this.mapAndFlush(dataStreams, codec.encoder());
    }

    public NettyChannel.Lifecycle on();

    public InetSocketAddress remoteAddress();

    default public Mono<Void> send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(dataStream);
    }

    default public Mono<Void> sendByteArray(Publisher<? extends byte[]> dataStream) {
        return this.send((Publisher<? extends ByteBuf>)Flux.from(dataStream).map(Unpooled::wrappedBuffer));
    }

    default public Mono<Void> sendByteBuffer(Publisher<? extends ByteBuffer> dataStream) {
        return this.send((Publisher<? extends ByteBuf>)Flux.from(dataStream).map(Unpooled::wrappedBuffer));
    }

    default public Mono<Void> sendFile(File file) {
        return this.sendFile(file, 0L, file.length());
    }

    default public Mono<Void> sendFile(File file, long position, long count) {
        return MonoChannelFuture.from((Future)this.delegate().writeAndFlush((Object)new DefaultFileRegion(file, position, count)));
    }

    public Mono<Void> sendObject(Publisher<?> var1);

    default public Mono<Void> sendString(Publisher<? extends String> dataStream) {
        return this.sendString(dataStream, Charset.defaultCharset());
    }

    default public Mono<Void> sendString(Publisher<? extends String> dataStream, Charset charset) {
        return this.send((Publisher<? extends ByteBuf>)Flux.from(dataStream).map(s -> this.delegate().alloc().buffer().writeBytes(s.getBytes(charset))));
    }
}

