/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

final class ReleasingBufferInputStream
extends ByteBufInputStream {
    final ByteBuf bb;
    volatile int closed;
    static final AtomicIntegerFieldUpdater<ReleasingBufferInputStream> CLOSE = AtomicIntegerFieldUpdater.newUpdater(ReleasingBufferInputStream.class, "closed");

    public ReleasingBufferInputStream(ByteBuf bb) {
        super(bb.retain());
        this.bb = bb;
    }

    public void close() throws IOException {
        if (CLOSE.compareAndSet(this, 0, 1)) {
            super.close();
            this.bb.release();
        }
    }
}

