/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.config;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.ipc.netty.common.DuplexSocket;
import reactor.ipc.netty.config.NettyOptions;

public class ClientOptions
extends NettyOptions<ClientOptions> {
    String proxyUsername;
    Function<? super String, ? extends String> proxyPassword;
    Supplier<? extends InetSocketAddress> proxyAddress;
    Proxy proxyType;
    Supplier<? extends InetSocketAddress> connectAddress;

    public static ClientOptions create() {
        return new ClientOptions();
    }

    public static ClientOptions to(String host) {
        return ClientOptions.to(host, DuplexSocket.DEFAULT_PORT);
    }

    public static ClientOptions to(String host, int port) {
        return ClientOptions.create().connect(host, port);
    }

    ClientOptions() {
    }

    public ClientOptions connect(@Nonnull String host, int port) {
        return this.connect(InetSocketAddress.createUnresolved(host, port));
    }

    public ClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
        return this.connect(new InetResolverSupplier(connectAddress, this));
    }

    public ClientOptions connect(@Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        if (this.connectAddress != null) {
            throw new IllegalStateException("Connect address is already set.");
        }
        this.connectAddress = connectAddress;
        return this;
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull String host, int port, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(type, InetSocketAddress.createUnresolved(host, port), username, password);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull String host, int port) {
        return this.proxy(type, InetSocketAddress.createUnresolved(host, port));
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull InetSocketAddress connectAddress) {
        return this.proxy(type, new InetResolverProxySupplier(connectAddress), null, null);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(type, new InetResolverProxySupplier(connectAddress), username, password);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        return this.proxy(type, connectAddress, null, null);
    }

    public ClientOptions proxy(@Nonnull Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        this.proxyUsername = username;
        this.proxyPassword = password;
        this.proxyAddress = Objects.requireNonNull(connectAddress, "addressSupplier");
        this.proxyType = Objects.requireNonNull(type, "proxyType");
        return this;
    }

    public InetSocketAddress remoteAddress() {
        return this.connectAddress != null ? this.connectAddress.get() : null;
    }

    public ClientOptions sslSupport() {
        this.ssl(SslContextBuilder.forClient());
        return this;
    }

    public String proxyUsername() {
        return this.proxyUsername;
    }

    public Function<? super String, ? extends String> proxyPassword() {
        return this.proxyPassword;
    }

    public Supplier<? extends InetSocketAddress> proxyAddress() {
        return this.proxyAddress;
    }

    public Proxy proxyType() {
        return this.proxyType;
    }

    public ClientOptions toImmutable() {
        return new ImmutableClientOptions(this);
    }

    static final class InetResolverProxySupplier
    implements Supplier<InetSocketAddress> {
        final InetSocketAddress connectAddress;

        public InetResolverProxySupplier(InetSocketAddress address) {
            this.connectAddress = address;
        }

        @Override
        public InetSocketAddress get() {
            return this.connectAddress.isUnresolved() ? new InetSocketAddress(this.connectAddress.getHostName(), this.connectAddress.getPort()) : this.connectAddress;
        }
    }

    static final class InetResolverSupplier
    implements Supplier<InetSocketAddress> {
        final InetSocketAddress connectAddress;
        final ClientOptions parent;

        public InetResolverSupplier(InetSocketAddress address, ClientOptions parent) {
            this.connectAddress = address;
            this.parent = parent;
        }

        @Override
        public InetSocketAddress get() {
            return this.connectAddress.isUnresolved() && this.parent.proxyType == null ? new InetSocketAddress(this.connectAddress.getHostName(), this.connectAddress.getPort()) : this.connectAddress;
        }
    }

    static final class ImmutableClientOptions
    extends ClientOptions {
        final ClientOptions options;

        ImmutableClientOptions(ClientOptions options) {
            this.options = options;
            if (options.ssl() != null) {
                super.ssl(options.ssl());
            }
        }

        @Override
        public ClientOptions toImmutable() {
            return this;
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return this.options.remoteAddress();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.options.eventLoopGroup();
        }

        @Override
        public boolean managed() {
            return this.options.managed();
        }

        @Override
        public boolean keepAlive() {
            return this.options.keepAlive();
        }

        @Override
        public int linger() {
            return this.options.linger();
        }

        @Override
        public Consumer<ChannelPipeline> pipelineConfigurer() {
            return this.options.pipelineConfigurer();
        }

        @Override
        public int rcvbuf() {
            return this.options.rcvbuf();
        }

        @Override
        public int sndbuf() {
            return this.options.sndbuf();
        }

        @Override
        public ClientOptions sslSupport() {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions timeoutMillis(long timeout) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public boolean tcpNoDelay() {
            return this.options.tcpNoDelay();
        }

        @Override
        public long timeoutMillis() {
            return this.options.timeoutMillis();
        }

        @Override
        public Proxy proxyType() {
            return this.options.proxyType();
        }

        @Override
        public String proxyUsername() {
            return this.options.proxyUsername();
        }

        @Override
        public Function<? super String, ? extends String> proxyPassword() {
            return this.options.proxyPassword();
        }

        @Override
        public Supplier<? extends InetSocketAddress> proxyAddress() {
            return this.options.proxyAddress();
        }

        @Override
        public ClientOptions daemon(boolean daemon) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public boolean daemon() {
            return this.options.daemon();
        }

        @Override
        public long sslHandshakeTimeoutMillis() {
            return this.options.sslHandshakeTimeoutMillis();
        }

        @Override
        public ClientOptions connect(@Nonnull String host, int port) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions proxy(@Nonnull Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions eventLoopGroup(EventLoopGroup eventLoopGroup) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions keepAlive(boolean keepAlive) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions linger(int linger) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions managed(boolean managed) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions pipelineConfigurer(Consumer<ChannelPipeline> pipelineConfigurer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions rcvbuf(int rcvbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions ssl(SslContextBuilder sslOptions) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions sslConfigurer(Consumer<? super SslContextBuilder> consumer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions sndbuf(int sndbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions tcpNoDelay(boolean tcpNoDelay) {
            throw new UnsupportedOperationException("Immutable Options");
        }
    }

    public static enum Proxy {
        HTTP,
        SOCKS4,
        SOCKS5;

    }
}

