/*
 * Decompiled with CFR 0.152.
 */
package reactor.ipc.netty.config;

import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContextBuilder;
import java.net.InetSocketAddress;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import reactor.ipc.netty.common.DuplexSocket;
import reactor.ipc.netty.config.ClientOptions;

public class HttpClientOptions
extends ClientOptions {
    public static HttpClientOptions create() {
        return new HttpClientOptions();
    }

    public static HttpClientOptions to(String host) {
        return HttpClientOptions.to(host, DuplexSocket.DEFAULT_PORT);
    }

    public static HttpClientOptions to(String host, int port) {
        return HttpClientOptions.create().connect(host, port);
    }

    HttpClientOptions() {
    }

    @Override
    public HttpClientOptions connect(@Nonnull String host, int port) {
        return this.connect(InetSocketAddress.createUnresolved(host, port));
    }

    @Override
    public HttpClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
        return this.connect((Supplier)new ClientOptions.InetResolverSupplier(connectAddress, this));
    }

    @Override
    public HttpClientOptions connect(@Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        super.connect(connectAddress);
        return this;
    }

    public ClientOptions proxy(@Nonnull String host, int port) {
        return this.proxy(InetSocketAddress.createUnresolved(host, port));
    }

    public ClientOptions proxy(@Nonnull String host, int port, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(InetSocketAddress.createUnresolved(host, port), username, password);
    }

    public ClientOptions proxy(@Nonnull InetSocketAddress connectAddress) {
        return this.proxy(new ClientOptions.InetResolverProxySupplier(connectAddress), null, null);
    }

    public ClientOptions proxy(@Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        return this.proxy(new ClientOptions.InetResolverProxySupplier(connectAddress), username, password);
    }

    @Override
    public ClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress) {
        return this.proxy(connectAddress, null, null);
    }

    public ClientOptions proxy(@Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
        this.proxy(ClientOptions.Proxy.HTTP, connectAddress, username, password);
        return this;
    }

    @Override
    public HttpClientOptions sslSupport() {
        this.ssl(SslContextBuilder.forClient());
        return this;
    }

    @Override
    public HttpClientOptions toImmutable() {
        return new ImmutableHttpClientOptions(this);
    }

    static final class ImmutableHttpClientOptions
    extends HttpClientOptions {
        final HttpClientOptions options;

        ImmutableHttpClientOptions(HttpClientOptions options) {
            this.options = options;
            if (options.ssl() != null) {
                super.ssl(options.ssl());
            }
        }

        @Override
        public HttpClientOptions toImmutable() {
            return this;
        }

        @Override
        public String proxyUsername() {
            return this.options.proxyUsername();
        }

        @Override
        public Function<? super String, ? extends String> proxyPassword() {
            return this.options.proxyPassword();
        }

        @Override
        public Supplier<? extends InetSocketAddress> proxyAddress() {
            return this.options.proxyAddress();
        }

        @Override
        public ClientOptions.Proxy proxyType() {
            return this.options.proxyType();
        }

        @Override
        public InetSocketAddress remoteAddress() {
            return this.options.remoteAddress();
        }

        @Override
        public EventLoopGroup eventLoopGroup() {
            return this.options.eventLoopGroup();
        }

        @Override
        public boolean managed() {
            return this.options.managed();
        }

        @Override
        public boolean keepAlive() {
            return this.options.keepAlive();
        }

        @Override
        public int linger() {
            return this.options.linger();
        }

        @Override
        public Consumer<ChannelPipeline> pipelineConfigurer() {
            return this.options.pipelineConfigurer();
        }

        @Override
        public int rcvbuf() {
            return this.options.rcvbuf();
        }

        @Override
        public int sndbuf() {
            return this.options.sndbuf();
        }

        @Override
        public boolean tcpNoDelay() {
            return this.options.tcpNoDelay();
        }

        @Override
        public long timeoutMillis() {
            return this.options.timeoutMillis();
        }

        @Override
        public HttpClientOptions sslSupport() {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull InetSocketAddress connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
            return super.proxy(type, connectAddress, username, password);
        }

        @Override
        public ClientOptions timeoutMillis(long timeout) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions sslHandshakeTimeoutMillis(long sslHandshakeTimeoutMillis) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public long sslHandshakeTimeoutMillis() {
            return this.options.sslHandshakeTimeoutMillis();
        }

        @Override
        public HttpClientOptions connect(@Nonnull String host, int port) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions connect(@Nonnull InetSocketAddress connectAddress) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions eventLoopGroup(EventLoopGroup eventLoopGroup) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions keepAlive(boolean keepAlive) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public ClientOptions proxy(@Nonnull ClientOptions.Proxy type, @Nonnull Supplier<? extends InetSocketAddress> connectAddress, @Nullable String username, @Nullable Function<? super String, ? extends String> password) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions linger(int linger) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions managed(boolean managed) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions pipelineConfigurer(Consumer<ChannelPipeline> pipelineConfigurer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions rcvbuf(int rcvbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions daemon(boolean daemon) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public boolean daemon() {
            return this.options.daemon();
        }

        @Override
        public HttpClientOptions ssl(SslContextBuilder sslOptions) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions sslConfigurer(Consumer<? super SslContextBuilder> consumer) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions sndbuf(int sndbuf) {
            throw new UnsupportedOperationException("Immutable Options");
        }

        @Override
        public HttpClientOptions tcpNoDelay(boolean tcpNoDelay) {
            throw new UnsupportedOperationException("Immutable Options");
        }
    }
}

